/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.MassSpectrumUnknownSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.PeakUnknownSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.support.TargetBuilder;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;

public class UnknownIdentifier {
    public static final String IDENTIFIER = "Unknown Identifier";
    private static final TargetBuilder TARGETBUILDER = new TargetBuilder();

    public void runIdentification(List<? extends IPeakMSD> peaks, PeakUnknownSettings settings) {
        float minMatchFactor = settings.getMinMatchFactor();
        float minReverseMatchFactor = settings.getMinReverseMatchFactor();
        for (IPeakMSD iPeakMSD : peaks) {
            if (!this.identifyPeak((IPeak)iPeakMSD, minMatchFactor, minReverseMatchFactor)) continue;
            TARGETBUILDER.setPeakTargetUnknown(iPeakMSD, IDENTIFIER);
        }
    }

    public void runIdentification(List<IScanMSD> massSpectraList, MassSpectrumUnknownSettings settings) {
        float minMatchFactor = settings.getMinMatchFactor();
        float minReverseMatchFactor = settings.getMinReverseMatchFactor();
        for (IScanMSD scan : massSpectraList) {
            if (!this.identifyScan(scan, minMatchFactor, minReverseMatchFactor)) continue;
            TARGETBUILDER.setMassSpectrumTargetUnknown(scan, IDENTIFIER);
        }
    }

    private boolean identifyPeak(IPeak peak, float minMatchFactor, float minReverseMatchFactor) {
        for (IIdentificationTarget target : peak.getTargets()) {
            IComparisonResult comparisonResult = target.getComparisonResult();
            if (!(comparisonResult.getMatchFactor() >= minMatchFactor) || !(comparisonResult.getReverseMatchFactor() >= minReverseMatchFactor)) continue;
            return false;
        }
        return true;
    }

    private boolean identifyScan(IScanMSD scan, float minMatchFactor, float minReverseMatchFactor) {
        for (IIdentificationTarget target : scan.getTargets()) {
            IComparisonResult comparisonResult = target.getComparisonResult();
            if (!(comparisonResult.getMatchFactor() >= minMatchFactor) || !(comparisonResult.getReverseMatchFactor() >= minReverseMatchFactor)) continue;
            return false;
        }
        return true;
    }
}

