/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.Activator;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.MassSpectrumUnknownSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.PeakUnknownSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.chemclipse.support.util.FileListUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceSupplier
implements IPreferenceSupplier {
    private static final Logger logger = Logger.getLogger(PreferenceSupplier.class);
    public static final float MIN_FACTOR = 0.0f;
    public static final float MAX_FACTOR = 100.0f;
    public static final String P_MASS_SPECTRA_FILES = "massSpectraFiles";
    public static final String DEF_MASS_SPECTRA_FILES = "";
    public static final String P_MASS_SPECTRUM_COMPARATOR_ID = "massSpectrumComparatorId";
    public static final String DEF_MASS_SPECTRUM_COMPARATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.incos";
    public static final String P_USE_PRE_OPTIMIZATION = "usePreOptimization";
    public static final Boolean DEF_USE_PRE_OPTIMIZATION = true;
    public static final String P_THRESHOLD_PRE_OPTIMIZATION = "thresholdPreOptimization";
    public static final double DEF_THRESHOLD_PRE_OPTIMIZATION = 0.1;
    public static final double MIN_THRESHOLD_PRE_OPTIMIZATION = 0.0;
    public static final double MAX_THRESHOLD_PRE_OPTIMIZATION = 1.0;
    public static final String P_NUMBER_OF_TARGETS = "numberOfTargets";
    public static final int DEF_NUMBER_OF_TARGETS = 3;
    public static final int MIN_NUMBER_OF_TARGETS = 1;
    public static final int MAX_NUMBER_OF_TARGETS = 100;
    public static final String P_MIN_MATCH_FACTOR = "minMatchFactor";
    public static final float DEF_MIN_MATCH_FACTOR = 80.0f;
    public static final String P_MIN_REVERSE_MATCH_FACTOR = "minReverseMatchFactor";
    public static final float DEF_MIN_REVERSE_MATCH_FACTOR = 80.0f;
    public static final String P_MIN_MATCH_FACTOR_UNKNOWN = "minMatchFactorUnknown";
    public static final float DEF_MIN_MATCH_FACTOR_UNKNOWN = 80.0f;
    public static final String P_MIN_REVERSE_MATCH_FACTOR_UNKNOWN = "minReverseMatchFactorUnknown";
    public static final float DEF_MIN_REVERSE_MATCH_FACTOR_UNKNOWN = 80.0f;
    public static final String P_PENALTY_CALCULATION = "penaltyCalculation";
    public static final String DEF_PENALTY_CALCULATION = "NONE";
    public static final String P_PENALTY_CALCULATION_LEVEL_FACTOR = "penaltyCalculationLevelFactor";
    public static final String P_MAX_PENALTY = "maxPenalty";
    public static final String P_RETENTION_TIME_WINDOW = "retentionTimeWindow";
    public static final int DEF_RETENTION_TIME_WINDOW = 12000;
    public static final int MIN_RETENTION_TIME_WINDOW = 60;
    public static final int MAX_RETENTION_TIME_WINDOW = 60000;
    public static final String P_RETENTION_INDEX_WINDOW = "retentionIndexWindow";
    public static final float DEF_RETENTION_INDEX_WINDOW = 20.0f;
    public static final float MIN_RETENTION_INDEX_WINDOW = 10.0f;
    public static final float MAX_RETENTION_INDEX_WINDOW = 20.0f;
    public static final String P_FILTER_PATH_IDENTIFIER_FILES = "filterPathIdentifierFiles";
    public static final String DEF_FILTER_PATH_IDENTIFIER_FILES = "";
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_MASS_SPECTRA_FILES, "");
        defaultValues.put(P_MASS_SPECTRUM_COMPARATOR_ID, DEF_MASS_SPECTRUM_COMPARATOR_ID);
        defaultValues.put(P_USE_PRE_OPTIMIZATION, Boolean.toString(DEF_USE_PRE_OPTIMIZATION));
        defaultValues.put(P_THRESHOLD_PRE_OPTIMIZATION, Double.toString(0.1));
        defaultValues.put(P_NUMBER_OF_TARGETS, Integer.toString(3));
        defaultValues.put(P_MIN_MATCH_FACTOR, Float.toString(80.0f));
        defaultValues.put(P_MIN_REVERSE_MATCH_FACTOR, Float.toString(80.0f));
        defaultValues.put(P_MIN_MATCH_FACTOR_UNKNOWN, Float.toString(80.0f));
        defaultValues.put(P_MIN_REVERSE_MATCH_FACTOR_UNKNOWN, Float.toString(80.0f));
        defaultValues.put(P_PENALTY_CALCULATION, DEF_PENALTY_CALCULATION);
        defaultValues.put(P_PENALTY_CALCULATION_LEVEL_FACTOR, Float.toString(5.0f));
        defaultValues.put(P_MAX_PENALTY, Float.toString(20.0f));
        defaultValues.put(P_RETENTION_TIME_WINDOW, Integer.toString(12000));
        defaultValues.put(P_RETENTION_INDEX_WINDOW, Float.toString(20.0f));
        defaultValues.put(P_FILTER_PATH_IDENTIFIER_FILES, "");
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static MassSpectrumIdentifierSettings getMassSpectrumIdentifierSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        MassSpectrumIdentifierSettings settings = new MassSpectrumIdentifierSettings();
        settings.setMassSpectraFiles(preferences.get(P_MASS_SPECTRA_FILES, ""));
        settings.setUsePreOptimization(preferences.getBoolean(P_USE_PRE_OPTIMIZATION, DEF_USE_PRE_OPTIMIZATION.booleanValue()));
        settings.setThresholdPreOptimization(preferences.getDouble(P_THRESHOLD_PRE_OPTIMIZATION, 0.1));
        settings.setMassSpectrumComparatorId(preferences.get(P_MASS_SPECTRUM_COMPARATOR_ID, DEF_MASS_SPECTRUM_COMPARATOR_ID));
        settings.setNumberOfTargets(preferences.getInt(P_NUMBER_OF_TARGETS, 3));
        settings.setMinMatchFactor(preferences.getFloat(P_MIN_MATCH_FACTOR, 80.0f));
        settings.setMinReverseMatchFactor(preferences.getFloat(P_MIN_REVERSE_MATCH_FACTOR, 80.0f));
        settings.setPenaltyCalculation(preferences.get(P_PENALTY_CALCULATION, DEF_PENALTY_CALCULATION));
        settings.setPenaltyCalculationLevelFactor(preferences.getFloat(P_PENALTY_CALCULATION_LEVEL_FACTOR, 5.0f));
        settings.setMaxPenalty(preferences.getFloat(P_MAX_PENALTY, 20.0f));
        settings.setRetentionTimeWindow(preferences.getInt(P_RETENTION_TIME_WINDOW, 12000));
        settings.setRetentionIndexWindow(preferences.getFloat(P_RETENTION_INDEX_WINDOW, 20.0f));
        return settings;
    }

    public static PeakIdentifierSettings getPeakIdentifierSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        PeakIdentifierSettings settings = new PeakIdentifierSettings();
        settings.setMassSpectraFiles(preferences.get(P_MASS_SPECTRA_FILES, ""));
        settings.setUsePreOptimization(preferences.getBoolean(P_USE_PRE_OPTIMIZATION, DEF_USE_PRE_OPTIMIZATION.booleanValue()));
        settings.setThresholdPreOptimization(preferences.getDouble(P_THRESHOLD_PRE_OPTIMIZATION, 0.1));
        settings.setMassSpectrumComparatorId(preferences.get(P_MASS_SPECTRUM_COMPARATOR_ID, DEF_MASS_SPECTRUM_COMPARATOR_ID));
        settings.setNumberOfTargets(preferences.getInt(P_NUMBER_OF_TARGETS, 3));
        settings.setMinMatchFactor(preferences.getFloat(P_MIN_MATCH_FACTOR, 80.0f));
        settings.setMinReverseMatchFactor(preferences.getFloat(P_MIN_REVERSE_MATCH_FACTOR, 80.0f));
        settings.setPenaltyCalculation(preferences.get(P_PENALTY_CALCULATION, DEF_PENALTY_CALCULATION));
        settings.setPenaltyCalculationLevelFactor(preferences.getFloat(P_PENALTY_CALCULATION_LEVEL_FACTOR, 5.0f));
        settings.setMaxPenalty(preferences.getFloat(P_MAX_PENALTY, 20.0f));
        settings.setRetentionTimeWindow(preferences.getInt(P_RETENTION_TIME_WINDOW, 12000));
        settings.setRetentionIndexWindow(preferences.getFloat(P_RETENTION_INDEX_WINDOW, 20.0f));
        return settings;
    }

    public static PeakUnknownSettings getPeakUnknownSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        PeakUnknownSettings settings = new PeakUnknownSettings();
        settings.setMassSpectrumComparatorId("");
        settings.setMinMatchFactor(preferences.getFloat(P_MIN_MATCH_FACTOR_UNKNOWN, 80.0f));
        settings.setMinReverseMatchFactor(preferences.getFloat(P_MIN_REVERSE_MATCH_FACTOR_UNKNOWN, 80.0f));
        return settings;
    }

    public static MassSpectrumUnknownSettings getMassSpectrumUnknownSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        MassSpectrumUnknownSettings settings = new MassSpectrumUnknownSettings();
        settings.setMassSpectrumComparatorId("");
        settings.setMinMatchFactor(preferences.getFloat(P_MIN_MATCH_FACTOR_UNKNOWN, 80.0f));
        settings.setMinReverseMatchFactor(preferences.getFloat(P_MIN_REVERSE_MATCH_FACTOR_UNKNOWN, 80.0f));
        return settings;
    }

    public static List<String> getMassSpectraFiles() {
        FileListUtil fileListUtil = new FileListUtil();
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return fileListUtil.getFiles(preferences.get(P_MASS_SPECTRA_FILES, ""));
    }

    public static void setMassSpectraFiles(List<String> massSpectraFiles) {
        try {
            FileListUtil fileListUtil = new FileListUtil();
            IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
            String[] items = massSpectraFiles.toArray(new String[massSpectraFiles.size()]);
            preferences.put(P_MASS_SPECTRA_FILES, fileListUtil.createList(items));
            preferences.flush();
        }
        catch (BackingStoreException e) {
            logger.warn((Object)e);
        }
    }

    public static String getFilterPathIdentifierFiles() {
        return PreferenceSupplier.getFilterPath(P_FILTER_PATH_IDENTIFIER_FILES, "");
    }

    public static void setFilterPathIdentifierFiles(String filterPath) {
        PreferenceSupplier.setFilterPath(P_FILTER_PATH_IDENTIFIER_FILES, filterPath);
    }

    private static String getFilterPath(String key, String def) {
        IEclipsePreferences eclipsePreferences = PreferenceSupplier.INSTANCE().getPreferences();
        return eclipsePreferences.get(key, def);
    }

    private static void setFilterPath(String key, String filterPath) {
        try {
            IEclipsePreferences eclipsePreferences = PreferenceSupplier.INSTANCE().getPreferences();
            eclipsePreferences.put(key, filterPath);
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            logger.warn((Object)e);
        }
    }
}

