/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram;

import org.eclipse.chemclipse.chromatogram.msd.identifier.chromatogram.IChromatogramIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IIdentifierSettingsMSD;
import org.eclipse.chemclipse.model.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractChromatogramIdentifier
implements IChromatogramIdentifier {
    private static final String DESCRIPTION = "ChromatogramIdentifier";

    public IProcessingInfo validate(IChromatogramSelectionMSD chromatogramSelection, IIdentifierSettingsMSD identifierSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        try {
            this.validateChromatogramSelection(chromatogramSelection);
            this.validateSettings(identifierSettings);
        }
        catch (ValueMustNotBeNullException e) {
            processingInfo.addErrorMessage(DESCRIPTION, e.getMessage());
        }
        return processingInfo;
    }

    public void validateChromatogramSelection(IChromatogramSelectionMSD chromatogramSelection) throws ValueMustNotBeNullException {
        if (chromatogramSelection == null) {
            throw new ValueMustNotBeNullException("The chromatogram selection must not be null.");
        }
        if (chromatogramSelection.getChromatogram() == null) {
            throw new ValueMustNotBeNullException("The chromatogram must not be null.");
        }
    }

    public void validateSettings(IIdentifierSettingsMSD identifierSettings) throws ValueMustNotBeNullException {
        if (identifierSettings == null) {
            throw new ValueMustNotBeNullException("The identifier settings must not be null.");
        }
    }
}

