/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.Activator;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.peakmax.settings.PeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IAreaSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IIntegrationSupport;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.chemclipse.support.util.IonSettingUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_SELECTED_IONS = "selectedIons";
    public static final String DEF_SELECTED_IONS = "0";
    public static final String P_MINIMUM_PEAK_WIDTH = "minimumPeakWidth";
    public static final int DEF_MINIMUM_PEAK_WIDTH = 0;
    public static final String P_MINIMUM_SIGNAL_TO_NOISE_RATIO = "minimumSignalToNoiseRatio";
    public static final int DEF_MINIMUM_SIGNAL_TO_NOISE_RATIO = 0;
    public static final String P_MINIMUM_PEAK_AREA = "minimumPeakArea";
    public static final int DEF_MINIMUM_PEAK_AREA = 0;
    public static final int MIN_RETENTION_TIME = 0;
    public static final int MAX_RETENTION_TIME = 60000;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_SELECTED_IONS, DEF_SELECTED_IONS);
        defaultValues.put(P_MINIMUM_PEAK_AREA, Integer.toString(0));
        defaultValues.put(P_MINIMUM_PEAK_WIDTH, Integer.toString(0));
        defaultValues.put(P_MINIMUM_SIGNAL_TO_NOISE_RATIO, Integer.toString(0));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static PeakIntegrationSettings getPeakIntegrationSettings() {
        PeakIntegrationSettings peakIntegrationSettings = new PeakIntegrationSettings();
        IAreaSupport areaSupport = peakIntegrationSettings.getAreaSupport();
        areaSupport.setMinimumArea((double)PreferenceSupplier.getMinimumPeakArea());
        IIntegrationSupport integrationSupport = peakIntegrationSettings.getIntegrationSupport();
        integrationSupport.setMinimumPeakWidth(PreferenceSupplier.getMinimumPeakWidth());
        integrationSupport.setMinimumSignalToNoiseRatio((float)PreferenceSupplier.getMinimumSignalToNoiseRatio());
        IMarkedIons selectedIons = peakIntegrationSettings.getSelectedIons();
        String ions = PreferenceSupplier.getIons(P_SELECTED_IONS, DEF_SELECTED_IONS);
        IonSettingUtil settingIon = new IonSettingUtil();
        selectedIons.add(settingIon.extractIons(settingIon.deserialize(ions)));
        return peakIntegrationSettings;
    }

    public static int getMinimumPeakWidth() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_MINIMUM_PEAK_WIDTH, 0);
    }

    public static int getMinimumSignalToNoiseRatio() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_MINIMUM_SIGNAL_TO_NOISE_RATIO, 0);
    }

    public static int getMinimumPeakArea() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_MINIMUM_PEAK_AREA, 0);
    }

    public static String getIons(String preference, String def) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(preference, def);
    }
}

