/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.internal.report;

import java.io.PrintWriter;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;

public class PeakReport {
    private PeakReport() {
    }

    public static void writeResults(IPeaks<?> peaks, PrintWriter printWriter, String integrator, String identifier) {
        if (peaks == null || printWriter == null) {
            return;
        }
        printWriter.println("########");
        printWriter.println("Integrator: " + integrator);
        printWriter.println("Identifier: " + identifier);
        printWriter.println("########");
        for (IPeak peak : peaks.getPeaks()) {
            if (!(peak instanceof IPeakMSD)) continue;
            PeakReport.writeResult((IPeakMSD)peak, printWriter);
        }
        printWriter.println("");
    }

    private static void writeResult(IPeakMSD peak, PrintWriter printWriter) {
        printWriter.println("----------------------------------------------");
        printWriter.println("Model Description: " + peak.getModelDescription());
        printWriter.println("----------------------------------------------");
        printWriter.println("~~~~~~~~");
        printWriter.println("Integration Results");
        printWriter.println("~~~~~~~~");
        PeakReport.printIntegrationResults(peak, printWriter);
        printWriter.println("");
        printWriter.println("~~~~~~~~");
        printWriter.println("Identification Results");
        printWriter.println("~~~~~~~~");
        PeakReport.printIdentificationResults(peak, printWriter);
        printWriter.println("");
    }

    private static void printIntegrationResults(IPeakMSD peak, PrintWriter printWriter) {
        printWriter.println("Start RT (Minutes): " + (double)peak.getPeakModel().getStartRetentionTime() / 60000.0);
        printWriter.println("Stop RT (Minutes): " + (double)peak.getPeakModel().getStopRetentionTime() / 60000.0);
        printWriter.println("Tailing: " + peak.getPeakModel().getTailing());
        printWriter.println("Width (Minutes): " + (double)peak.getPeakModel().getWidthByInflectionPoints(0.5f) / 60000.0);
        printWriter.println("Integrated Area: " + peak.getIntegratedArea());
    }

    private static void printIdentificationResults(IPeakMSD peak, PrintWriter printWriter) {
        printWriter.print("Name");
        printWriter.print("\t");
        printWriter.print("CAS");
        printWriter.print("\t");
        printWriter.print("MatchFactor");
        printWriter.print("\t");
        printWriter.print("ReverseMatchFactor");
        printWriter.print("\t");
        printWriter.print("Probability");
        printWriter.print("\t");
        printWriter.print("Identifier");
        printWriter.print("\t");
        printWriter.print("Miscellaneous");
        printWriter.print("\t");
        printWriter.print("Comments");
        printWriter.println("");
        for (IIdentificationTarget peakTarget : peak.getTargets()) {
            if (!(peakTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget peakIdentificationEntry = peakTarget;
            IComparisonResult comparisonResult = peakIdentificationEntry.getComparisonResult();
            ILibraryInformation libraryInformation = peakIdentificationEntry.getLibraryInformation();
            printWriter.print(libraryInformation.getName());
            printWriter.print("\t");
            printWriter.print(libraryInformation.getCasNumber());
            printWriter.print("\t");
            printWriter.print(comparisonResult.getMatchFactor());
            printWriter.print("\t");
            printWriter.print(comparisonResult.getReverseMatchFactor());
            printWriter.print("\t");
            printWriter.print(comparisonResult.getProbability());
            printWriter.print("\t");
            printWriter.print(peakIdentificationEntry.getIdentifier());
            printWriter.print("\t");
            printWriter.print(libraryInformation.getMiscellaneous());
            printWriter.print("\t");
            printWriter.print(libraryInformation.getComments());
            printWriter.println("");
        }
    }
}

