/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.settings.IPeakQuantifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.calculator.QuantitationCalculatorMSD;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.core.AbstractPeakQuantitationCalculator;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io.DatabaseSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakQuantitationCalculatorESTD
extends AbstractPeakQuantitationCalculator {
    public IProcessingInfo quantify(List<IPeak> peaks, IPeakQuantifierSettings peakQuantifierSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        DatabaseSupport databaseSupport = new DatabaseSupport();
        IQuantitationDatabase quantitationDatabase = databaseSupport.load();
        if (quantitationDatabase != null && quantitationDatabase.size() > 0) {
            QuantitationCalculatorMSD calculator = new QuantitationCalculatorMSD();
            for (IPeak peakMSD : peaks) {
                Set<IQuantitationCompound> quantitationCompoundsMSD = this.getQuantitationEntries((Set<IQuantitationCompound>)quantitationDatabase, peakMSD);
                List<IQuantitationEntry> entries = calculator.calculateQuantitationResults(peakMSD, quantitationCompoundsMSD, (IProcessingInfo)processingInfo);
                for (IQuantitationEntry quantitationEntry : entries) {
                    peakMSD.addQuantitationEntry(quantitationEntry);
                }
            }
        } else {
            processingInfo.addErrorMessage("ChemClipse Quantitation", "Please select a quantitation database.");
        }
        return processingInfo;
    }

    private Set<IQuantitationCompound> getQuantitationEntries(Set<IQuantitationCompound> quantitationCompounds, IPeak peakToQuantify) {
        String quantitationStratregy = PreferenceSupplier.getQuantitationStrategy();
        HashSet<IQuantitationCompound> filteredQuantitationCompounds = new HashSet<IQuantitationCompound>();
        block10: for (IQuantitationCompound quantitationCompound : quantitationCompounds) {
            switch (quantitationStratregy) {
                case "RT": {
                    int retentionTime = peakToQuantify.getPeakModel().getRetentionTimeAtPeakMaximum();
                    IRetentionTimeWindow retentionTimeWindow = quantitationCompound.getRetentionTimeWindow();
                    if (!retentionTimeWindow.isRetentionTimeInWindow(retentionTime)) continue block10;
                    filteredQuantitationCompounds.add(quantitationCompound);
                    break;
                }
                case "REFS": {
                    if (!this.doQuantify(peakToQuantify, quantitationCompound.getName())) continue block10;
                    filteredQuantitationCompounds.add(quantitationCompound);
                    break;
                }
                case "NAME": {
                    if (!this.isIdentifierMatch(peakToQuantify, quantitationCompound.getName())) continue block10;
                    filteredQuantitationCompounds.add(quantitationCompound);
                    break;
                }
                default: {
                    filteredQuantitationCompounds.add(quantitationCompound);
                }
            }
        }
        return filteredQuantitationCompounds;
    }
}

