/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.settings.IPeakQuantifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.core.AbstractPeakQuantitationCalculator;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.implementation.QuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakQuantitationCalculatorISTD
extends AbstractPeakQuantitationCalculator {
    public IProcessingInfo quantifySelectedPeak(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        List<? extends IPeak> internalStandardPeaks = this.getInternalStandardPeaks(chromatogram);
        IPeak peakToQuantify = chromatogramSelection.getSelectedPeak();
        this.quantifyPeak(internalStandardPeaks, peakToQuantify);
        return processingInfo;
    }

    public IProcessingInfo quantifyAllPeaks(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        List<? extends IPeak> internalStandardPeaks = this.getInternalStandardPeaks(chromatogram);
        List<IPeak> peaksToQuantify = this.getPeaksToQuantify(chromatogramSelection);
        for (IPeak peakToQuantify : peaksToQuantify) {
            this.quantifyPeak(internalStandardPeaks, peakToQuantify);
        }
        return processingInfo;
    }

    public IProcessingInfo quantify(List<IPeak> peaks, IPeakQuantifierSettings peakQuantifierSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ArrayList<IPeak> internalStandardPeaks = new ArrayList<IPeak>();
        for (IPeak peak : peaks) {
            if (peak.getInternalStandards().size() <= 0) continue;
            internalStandardPeaks.add(peak);
        }
        for (IPeak peakToQuantify : peaks) {
            this.quantifyPeak(internalStandardPeaks, peakToQuantify);
        }
        return processingInfo;
    }

    private void quantifyPeak(List<? extends IPeak> internalStandardPeaks, IPeak peakToQuantify) {
        for (IPeak iPeak : internalStandardPeaks) {
            if (!this.isAreaValid(peakToQuantify, iPeak)) continue;
            for (IInternalStandard internalStandard : iPeak.getInternalStandards()) {
                String nameOfStandard = internalStandard.getName();
                if (!this.doQuantify(peakToQuantify, nameOfStandard)) continue;
                double peakAreaISTD = iPeak.getIntegratedArea();
                double concentration = internalStandard.getConcentration();
                String concentrationUnit = internalStandard.getConcentrationUnit();
                double responseFactor = internalStandard.getResponseFactor();
                String chemicalClass = internalStandard.getChemicalClass();
                double integratedArea = peakToQuantify.getIntegratedArea();
                double concentrationCalculated = concentration / peakAreaISTD * integratedArea * responseFactor;
                QuantitationEntry quantitationEntryMSD = new QuantitationEntry(nameOfStandard, concentrationCalculated, concentrationUnit, integratedArea);
                quantitationEntryMSD.setSignal(0.0);
                quantitationEntryMSD.setCalibrationMethod(CalibrationMethod.ISTD.toString());
                quantitationEntryMSD.setUsedCrossZero(false);
                quantitationEntryMSD.setChemicalClass(chemicalClass);
                peakToQuantify.addQuantitationEntry((IQuantitationEntry)quantitationEntryMSD);
            }
        }
    }

    private List<? extends IPeak> getInternalStandardPeaks(IChromatogram chromatogram) {
        if (chromatogram != null) {
            if (chromatogram instanceof IChromatogramMSD) {
                ArrayList<IChromatogramPeakMSD> internalStandardPeaks = new ArrayList<IChromatogramPeakMSD>();
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                for (IChromatogramPeakMSD peak : chromatogramMSD.getPeaks()) {
                    if (peak.getInternalStandards().size() <= 0) continue;
                    internalStandardPeaks.add(peak);
                }
                return internalStandardPeaks;
            }
            if (chromatogram instanceof IChromatogramCSD) {
                ArrayList<IChromatogramPeakCSD> internalStandardPeaks = new ArrayList<IChromatogramPeakCSD>();
                IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
                for (IChromatogramPeakCSD peak : chromatogramCSD.getPeaks()) {
                    if (peak.getInternalStandards().size() <= 0) continue;
                    internalStandardPeaks.add(peak);
                }
                return internalStandardPeaks;
            }
        }
        return new ArrayList();
    }

    private List<IPeak> getPeaksToQuantify(IChromatogramSelection chromatogramSelection) {
        ArrayList<IPeak> peaksToQuantify;
        block3: {
            block2: {
                peaksToQuantify = new ArrayList<IPeak>();
                if (!(chromatogramSelection instanceof IChromatogramSelectionMSD)) break block2;
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                for (IChromatogramPeakMSD peak : chromatogramSelectionMSD.getChromatogramMSD().getPeaks((IRetentionTimeRange)chromatogramSelectionMSD)) {
                    peaksToQuantify.add((IPeak)peak);
                }
                break block3;
            }
            if (!(chromatogramSelection instanceof IChromatogramSelectionCSD)) break block3;
            IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)chromatogramSelection;
            for (IChromatogramPeakCSD peak : chromatogramSelectionCSD.getChromatogramCSD().getPeaks((IRetentionTimeRange)chromatogramSelectionCSD)) {
                peaksToQuantify.add((IPeak)peak);
            }
        }
        return peaksToQuantify;
    }
}

