/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.Activator;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.settings.PeakDatabaseSettings;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.settings.PeakQuantifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceSupplier
implements IPreferenceSupplier {
    private static Logger logger = Logger.getLogger(PreferenceSupplier.class);
    public static final String P_USE_QUANTITATION_DATABASE_EDITOR = "useQuantitationDatabaseEditor";
    public static final boolean DEF_USE_QUANTITATION_DATABASE_EDITOR = false;
    public static final String P_SELECTED_QUANTITATION_DATABASE = "selectedQuantitationDatabase";
    public static final String DEF_SELECTED_QUANTITATION_DATABASE = "";
    public static final String P_FILTER_PATH_NEW_QUANT_DB = "filterPathNewQuantDB";
    public static final String DEF_FILTER_PATH_NEW_QUANT_DB = "";
    public static final double MIN_RETENTION_TIME = 0.0;
    public static final double MAX_RETENTION_TIME = Double.MAX_VALUE;
    public static final String P_RETENTION_TIME_NEGATIVE_DEVIATION = "retentionTimeNegativeDeviation";
    public static final double DEF_RETENTION_TIME_NEGATIVE_DEVIATION = 0.5;
    public static final String P_RETENTION_TIME_POSITIVE_DEVIATION = "retentionTimePositiveDeviation";
    public static final double DEF_RETENTION_TIME_POSITIVE_DEVIATION = 0.5;
    public static final float MIN_RETENTION_INDEX = 0.0f;
    public static final float MAX_RETENTION_INDEX = Float.MAX_VALUE;
    public static final String P_RETENTION_INDEX_NEGATIVE_DEVIATION = "retentionIndexNegativeDeviation";
    public static final float DEF_RETENTION_INDEX_NEGATIVE_DEVIATION = 10.0f;
    public static final String P_RETENTION_INDEX_POSITIVE_DEVIATION = "retentionIndexPositiveDeviation";
    public static final float DEF_RETENTION_INDEX_POSITIVE_DEVIATION = 10.0f;
    public static final String QUANTITATION_STRATEGY_NONE = "NONE";
    public static final String QUANTITATION_STRATEGY_RETENTION_TIME = "RT";
    public static final String QUANTITATION_STRATEGY_REFERENCES = "REFS";
    public static final String QUANTITATION_STRATEGY_NAME = "NAME";
    public static final String[][] QUANTITATION_STRATEGY_OPTIONS = new String[][]{{"None", "NONE"}, {"Retention Time", "RT"}, {"References", "REFS"}, {"Name", "NAME"}};
    public static final String P_QUANTITATION_STRATEGY = "quantitationStrategy";
    public static final String DEF_QUANTITATION_STRATEGY = "NONE";
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_USE_QUANTITATION_DATABASE_EDITOR, Boolean.toString(false));
        defaultValues.put(P_SELECTED_QUANTITATION_DATABASE, "");
        defaultValues.put(P_FILTER_PATH_NEW_QUANT_DB, "");
        defaultValues.put(P_RETENTION_TIME_NEGATIVE_DEVIATION, Double.toString(0.5));
        defaultValues.put(P_RETENTION_TIME_POSITIVE_DEVIATION, Double.toString(0.5));
        defaultValues.put(P_RETENTION_INDEX_NEGATIVE_DEVIATION, Float.toString(10.0f));
        defaultValues.put(P_RETENTION_INDEX_POSITIVE_DEVIATION, Float.toString(10.0f));
        defaultValues.put(P_QUANTITATION_STRATEGY, "NONE");
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static String getSelectedQuantitationDatabase() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_SELECTED_QUANTITATION_DATABASE, "");
    }

    public static void setSelectedQuantitationDatabase(String selectedQuantitationDatabase) {
        try {
            IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
            preferences.put(P_SELECTED_QUANTITATION_DATABASE, selectedQuantitationDatabase);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            logger.warn((Object)e);
        }
    }

    public static PeakQuantifierSettings getPeakQuantifierSettings() {
        PeakQuantifierSettings peakQuantifierSettings = new PeakQuantifierSettings();
        return peakQuantifierSettings;
    }

    public static PeakDatabaseSettings getPeakDatabaseSettings() {
        PeakDatabaseSettings peakDatabaseSettings = new PeakDatabaseSettings();
        return peakDatabaseSettings;
    }

    public static String getFilterPathNewQuantDB() {
        return PreferenceSupplier.getFilterPath(P_FILTER_PATH_NEW_QUANT_DB, "");
    }

    public static void setFilterPathNewQuantDB(String filterPath) {
        PreferenceSupplier.setFilterPath(P_FILTER_PATH_NEW_QUANT_DB, filterPath);
    }

    public static double getRetentionTimeNegativeDeviation() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getDouble(P_RETENTION_TIME_NEGATIVE_DEVIATION, 0.5);
    }

    public static double getRetentionTimePositiveDeviation() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getDouble(P_RETENTION_TIME_POSITIVE_DEVIATION, 0.5);
    }

    public static float getRetentionIndexNegativeDeviation() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getFloat(P_RETENTION_INDEX_NEGATIVE_DEVIATION, 10.0f);
    }

    public static float getRetentionIndexPositiveDeviation() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getFloat(P_RETENTION_INDEX_POSITIVE_DEVIATION, 10.0f);
    }

    public static String getQuantitationStrategy() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_QUANTITATION_STRATEGY, "NONE");
    }

    private static String getFilterPath(String key, String def) {
        IEclipsePreferences eclipsePreferences = PreferenceSupplier.INSTANCE().getPreferences();
        return eclipsePreferences.get(key, def);
    }

    private static void setFilterPath(String key, String filterPath) {
        try {
            IEclipsePreferences eclipsePreferences = PreferenceSupplier.INSTANCE().getPreferences();
            eclipsePreferences.put(key, filterPath);
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            logger.warn((Object)e);
        }
    }
}

