/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.support.text.ValueFormat;

public class CalibrationFileWriter {
    private static final Logger logger = Logger.getLogger(CalibrationFileWriter.class);
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public void write(File file, ISeparationColumnIndices separationColumnIndices) {
        try {
            PrintWriter printWriter = new PrintWriter(file);
            ISeparationColumn separationColumn = separationColumnIndices.getSeparationColumn();
            if (separationColumn != null) {
                printWriter.println("#COLUMN_NAME=" + separationColumn.getName());
                printWriter.println("#COLUMN_LENGTH=" + separationColumn.getLength());
                printWriter.println("#COLUMN_DIAMETER=" + separationColumn.getDiameter());
                printWriter.println("#COLUMN_PHASE=" + separationColumn.getPhase());
            }
            for (IRetentionIndexEntry retentionIndexEntry : separationColumnIndices.values()) {
                printWriter.print(this.decimalFormat.format((double)retentionIndexEntry.getRetentionTime() / 60000.0));
                printWriter.print(" ");
                printWriter.print(retentionIndexEntry.getRetentionIndex());
                printWriter.print(" ");
                printWriter.print(100);
                printWriter.print(" ");
                printWriter.print(999);
                printWriter.print(" ");
                printWriter.println(retentionIndexEntry.getName());
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
    }
}

