/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.noise.dyson.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.results.ChromatogramSegmentation;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.NoiseSegment;
import org.eclipse.chemclipse.model.support.SegmentValidator;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.core.runtime.IProgressMonitor;

public class NoiseCalculator
implements INoiseCalculator {
    private IChromatogram<?> chromatogram;
    private float noiseValue = Float.NaN;

    public float getSignalToNoiseRatio(IChromatogram<?> chromatogram, float intensity) {
        if (chromatogram != this.chromatogram) {
            this.noiseValue = this.calculateNoiseFactorByDyson(chromatogram);
            this.chromatogram = chromatogram;
        }
        if (Float.isFinite(this.noiseValue) && this.noiseValue > 0.0f) {
            return intensity / this.noiseValue;
        }
        return Float.NaN;
    }

    private float calculateNoiseFactorByDyson(IChromatogram<?> chromatogram) {
        if (chromatogram != null) {
            List<NoiseSegment> noiseSegments = this.getNoiseSegments(chromatogram, null);
            ArrayList<Double> deltaNoiseHeights = new ArrayList<Double>();
            for (NoiseSegment noiseSegment : noiseSegments) {
                deltaNoiseHeights.add(noiseSegment.getNoiseFactor());
            }
            double medianNoiseHeight = Calculations.getMedian(deltaNoiseHeights);
            if (medianNoiseHeight > 0.0) {
                return (float)medianNoiseHeight;
            }
            return chromatogram.getMinSignal();
        }
        return Float.NaN;
    }

    private static Double getDeltaNoiseHeight(IAnalysisSegment segment, SegmentValidator segmentValidator, ITotalScanSignals signals) {
        int segmentWidth = segment.getWidth();
        if (segmentWidth < 1) {
            return null;
        }
        double[] values = new double[segmentWidth];
        int counter = 0;
        int scan = segment.getStartScan();
        while (scan <= segment.getStopScan()) {
            ITotalScanSignal signal = signals.getTotalScanSignal(scan);
            values[counter] = signal.getTotalSignal();
            ++counter;
            ++scan;
        }
        double mean = Calculations.getMean((double[])values);
        if (!segmentValidator.acceptSegment(values, mean)) {
            return null;
        }
        double highestValue = Calculations.getMax((double[])values);
        double lowestValue = Calculations.getMin((double[])values);
        return highestValue - lowestValue;
    }

    public List<NoiseSegment> getNoiseSegments(IChromatogram<?> chromatogram, IProgressMonitor monitor) {
        ChromatogramSegmentation segmentation;
        if (chromatogram != null && (segmentation = (ChromatogramSegmentation)chromatogram.getMeasurementResult(ChromatogramSegmentation.class)) != null) {
            SegmentValidator validator = new SegmentValidator();
            TotalScanSignals signals = new TotalScanSignals(chromatogram);
            ArrayList<NoiseSegment> result = new ArrayList<NoiseSegment>();
            for (IAnalysisSegment segment : segmentation.getResult()) {
                Double deltaNoiseHeight = NoiseCalculator.getDeltaNoiseHeight(segment, validator, (ITotalScanSignals)signals);
                if (deltaNoiseHeight == null) continue;
                result.add(new NormanDysonNoiseSegment(segment, deltaNoiseHeight));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static final class NormanDysonNoiseSegment
    implements NoiseSegment {
        private final IAnalysisSegment baseSegment;
        private final double noiseFactor;

        public NormanDysonNoiseSegment(IAnalysisSegment baseSegment, double noiseFactor) {
            this.baseSegment = baseSegment;
            this.noiseFactor = noiseFactor;
        }

        public int getStartScan() {
            return this.baseSegment.getStartScan();
        }

        public int getStopScan() {
            return this.baseSegment.getStopScan();
        }

        public double getNoiseFactor() {
            return this.noiseFactor;
        }

        public Collection<? extends IAnalysisSegment> getChildSegments() {
            return Collections.singleton(this.baseSegment);
        }

        public int getStartRetentionTime() {
            return this.baseSegment.getStartRetentionTime();
        }

        public int getStopRetentionTime() {
            return this.baseSegment.getStopRetentionTime();
        }
    }
}

