/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.noise.stein.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.results.ChromatogramSegmentation;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.NoiseSegment;
import org.eclipse.chemclipse.model.support.SegmentValidator;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.msd.model.noise.CalculatorSupport;
import org.eclipse.chemclipse.msd.model.noise.IonNoiseCalculator;
import org.eclipse.chemclipse.msd.model.noise.IonNoiseSegment;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class NoiseCalculator
implements IonNoiseCalculator {
    private IChromatogram<?> chromatogram;
    private float noiseFactor = Float.NaN;

    public float getSignalToNoiseRatio(IChromatogram<?> chromatogram, float intensity) {
        if (this.chromatogram != chromatogram) {
            this.noiseFactor = this.calculateNoiseFactorByStein(chromatogram);
            this.chromatogram = chromatogram;
        }
        if (Float.isFinite(this.noiseFactor) && this.noiseFactor > 0.0f) {
            return (float)(Math.sqrt(intensity) * (double)this.noiseFactor);
        }
        return Float.NaN;
    }

    private float calculateNoiseFactorByStein(IChromatogram<?> chromatogram) {
        if (chromatogram != null) {
            double median;
            ArrayList noiseFactors = new ArrayList();
            Consumer<NoiseSegment> consumer = segment -> {
                boolean bl = noiseFactors.add(segment.getNoiseFactor());
            };
            this.getNoiseSegments(chromatogram, null).forEach(consumer);
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                SegmentValidator segmentValidator = new SegmentValidator();
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogramMSD);
                IExtractedIonSignals extractedSignals = extractedIonSignalExtractor.getExtractedIonSignals();
                int startIon = extractedSignals.getStartIon();
                int stopIon = extractedSignals.getStopIon();
                int ion = startIon;
                while (ion <= stopIon) {
                    List<NoiseSegment> ionNoiseSegments = this.getNoiseSegments(ion, (ChromatogramSegmentation)chromatogram.getMeasurementResult(ChromatogramSegmentation.class), segmentValidator, extractedSignals);
                    ionNoiseSegments.forEach(consumer);
                    ++ion;
                }
            }
            if ((median = Calculations.getMedian(noiseFactors)) > 0.0) {
                return (float)median;
            }
            return chromatogram.getMinSignal();
        }
        return Float.NaN;
    }

    private static Double calculateNoiseFactor(SegmentValidator segmentValidator, float[] values) {
        double mean = Calculations.getMean((float[])values);
        if (!segmentValidator.acceptSegment(values, mean)) {
            return null;
        }
        double medianFromMedian = Calculations.getMedianDeviationFromMedian((float[])values);
        return medianFromMedian / Math.sqrt(mean);
    }

    public List<NoiseSegment> getNoiseSegments(IChromatogram<?> chromatogram, IProgressMonitor monitor) {
        ChromatogramSegmentation segmentation;
        if (chromatogram instanceof IChromatogramMSD) {
            return this.getNoiseSegments(chromatogram, 0.0, monitor);
        }
        if (chromatogram != null && (segmentation = (ChromatogramSegmentation)chromatogram.getMeasurementResult(ChromatogramSegmentation.class)) != null) {
            SegmentValidator segmentValidator = new SegmentValidator();
            TotalScanSignals signals = new TotalScanSignals(chromatogram);
            List segments = segmentation.getResult();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)segments.size());
            ArrayList<NoiseSegment> result = new ArrayList<NoiseSegment>();
            for (IAnalysisSegment segment : segments) {
                Double factor = NoiseCalculator.calculateNoiseFactor(segmentValidator, signals.getValues((IScanRange)segment));
                if (factor != null) {
                    SteinNoiseSegment noiseSegment = new SteinNoiseSegment(segment, factor);
                    result.add(noiseSegment);
                }
                subMonitor.worked(1);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<NoiseSegment> getNoiseSegments(IChromatogram<?> chromatogram, double ion, IProgressMonitor monitor) {
        if (chromatogram instanceof IChromatogramMSD) {
            IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
            ChromatogramSegmentation segmentation = (ChromatogramSegmentation)chromatogram.getMeasurementResult(ChromatogramSegmentation.class);
            if (segmentation != null) {
                SegmentValidator segmentValidator = new SegmentValidator();
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogramMSD);
                IExtractedIonSignals signals = extractedIonSignalExtractor.getExtractedIonSignals();
                return this.getNoiseSegments(ion, segmentation, segmentValidator, signals);
            }
        }
        return Collections.emptyList();
    }

    private List<NoiseSegment> getNoiseSegments(double ion, ChromatogramSegmentation segmentation, SegmentValidator segmentValidator, IExtractedIonSignals signals) {
        ArrayList<NoiseSegment> result = new ArrayList<NoiseSegment>();
        if (segmentation != null) {
            List segments = segmentation.getResult();
            for (IAnalysisSegment segment : segments) {
                IScanMSD scan;
                Double factor = NoiseCalculator.calculateNoiseFactor(segmentValidator, signals.getValues((IScanRange)segment, (int)ion));
                if (factor == null) continue;
                if (ion == 0.0) {
                    scan = CalculatorSupport.getCombinedMassSpectrum((IExtractedIonSignals)signals, (IScanRange)segment).normalize();
                } else {
                    try {
                        scan = new ScanMSD(Collections.singleton(new Ion(ion))).normalize();
                    }
                    catch (IonLimitExceededException e) {
                        scan = null;
                    }
                }
                result.add(new SteinIonNoiseSegment(segment, factor, ion, (IScan)scan));
            }
        }
        return result;
    }

    private static class SteinIonNoiseSegment
    extends SteinNoiseSegment
    implements IonNoiseSegment,
    IAdaptable {
        private final double ion;
        private final IScan combinedMassSpectrum;

        public SteinIonNoiseSegment(IAnalysisSegment baseSegment, double noiseFactor, double ion, IScan combinedMassSpectrum) {
            super(baseSegment, noiseFactor);
            this.ion = ion;
            this.combinedMassSpectrum = combinedMassSpectrum;
        }

        public double getIon() {
            return this.ion;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.isInstance(this.combinedMassSpectrum)) {
                return adapter.cast(this.combinedMassSpectrum);
            }
            return null;
        }
    }

    private static class SteinNoiseSegment
    implements NoiseSegment {
        private final IAnalysisSegment baseSegment;
        private final double noiseFactor;

        public SteinNoiseSegment(IAnalysisSegment baseSegment, double noiseFactor) {
            this.baseSegment = baseSegment;
            this.noiseFactor = noiseFactor;
        }

        public int getStartScan() {
            return this.baseSegment.getStartScan();
        }

        public int getStopScan() {
            return this.baseSegment.getStopScan();
        }

        public Collection<IAnalysisSegment> getChildSegments() {
            return Collections.singleton(this.baseSegment);
        }

        public double getNoiseFactor() {
            return this.noiseFactor;
        }

        public int getStartRetentionTime() {
            return this.baseSegment.getStartRetentionTime();
        }

        public int getStopRetentionTime() {
            return this.baseSegment.getStopRetentionTime();
        }
    }
}

