/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.identifier.supplier.manual.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.xxd.identifier.supplier.manual.ui.internal.wizards.IdentificationPage;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class IdentificationWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(IdentificationWizard.class);
    private static final float FACTOR = 100.0f;
    private IdentificationPage identificationPage;
    private IPeak peak;

    public IdentificationWizard(IPeak peak) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Peak Identification");
        this.peak = peak;
    }

    public void addPages() {
        this.identificationPage = new IdentificationPage("Manual Peak Identification");
        this.addPage((IWizardPage)this.identificationPage);
    }

    public boolean performFinish() {
        this.removeErrorMessage();
        String name = this.identificationPage.getIdentificationName();
        if (this.peak == null) {
            this.showErrorMessage("There is no peak selected.");
            return false;
        }
        if (name == null || name.equals("")) {
            this.showErrorMessage("Please select a name to identify the peak.");
            return false;
        }
        String casNumber = this.identificationPage.getCasNumber();
        String comments = this.identificationPage.getComments();
        String formula = this.identificationPage.getFormula();
        double molWeight = this.identificationPage.getMolWeight();
        PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
        libraryInformation.setName(name);
        libraryInformation.setCasNumber(casNumber);
        libraryInformation.setComments(comments);
        libraryInformation.setFormula(formula);
        libraryInformation.setMolWeight(molWeight);
        try {
            PeakComparisonResult comparisonResult = new PeakComparisonResult(100.0f, 100.0f, 100.0f, 100.0f, 100.0f);
            IdentificationTarget peakTarget = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
            peakTarget.setIdentifier("Manual Peak Identifier");
            if (this.peak instanceof ITargetSupplier) {
                this.peak.getTargets().add(peakTarget);
                return true;
            }
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
            return false;
        }
        return false;
    }

    private void showErrorMessage(String message) {
        this.identificationPage.setErrorMessage(message);
    }

    private void removeErrorMessage() {
        this.identificationPage.setErrorMessage(null);
    }
}

