/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.IBaselineSupport;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;

public class BaselineSupport
implements IBaselineSupport {
    private IBaselineModel baselineModel;
    private IBaselineModel baselineModelModified;

    public BaselineSupport() {
        this.baselineModel = null;
        this.baselineModelModified = null;
    }

    public BaselineSupport(IBaselineModel baselineModel) {
        if (baselineModel != null) {
            this.baselineModel = baselineModel;
            this.baselineModelModified = baselineModel.makeDeepCopy();
        }
    }

    @Override
    public IBaselineModel getBaselineModel() {
        return this.baselineModelModified;
    }

    @Override
    public void setBaselineModel(IBaselineModel baselineModel) {
        if (baselineModel != null) {
            this.baselineModel = baselineModel;
            this.baselineModelModified = baselineModel.makeDeepCopy();
        }
    }

    @Override
    public void reset() {
        if (this.baselineModel != null) {
            this.baselineModelModified = this.baselineModel.makeDeepCopy();
        }
    }

    @Override
    public void setBaselineBack(int retentionTime) {
        if (this.modelIsNotNull()) {
            float abundance = this.baselineModelModified.getBackgroundAbundance(retentionTime);
            this.baselineModelModified.addBaseline(1, retentionTime, abundance, abundance, true);
        }
    }

    @Override
    public void setBaselineHoldOn(int startRetentionTime, int stopRetentionTime) {
        if (this.modelIsNotNull()) {
            float abundance = this.baselineModelModified.getBackgroundAbundance(startRetentionTime);
            this.baselineModelModified.addBaseline(startRetentionTime, stopRetentionTime, abundance, abundance, true);
        }
    }

    @Override
    public void setBaselineNow(int retentionTime) {
        if (this.modelIsNotNull()) {
            float abundance = this.baselineModelModified.getBackgroundAbundance(retentionTime);
            this.baselineModelModified.addBaseline(retentionTime, Integer.MAX_VALUE, abundance, abundance, true);
        }
    }

    @Override
    public float getBackgroundAbundance(int retentionTime) {
        float result = 0.0f;
        if (this.modelIsNotNull()) {
            result = this.baselineModelModified.getBackgroundAbundance(retentionTime);
        }
        return result;
    }

    private boolean modelIsNotNull() {
        boolean result = true;
        if (this.baselineModelModified == null) {
            result = false;
        }
        return result;
    }
}

