/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.core.IPeakDetectorMSD;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.IPeakDetectorSettingsMSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.FilterMode;
import org.eclipse.chemclipse.chromatogram.peak.detector.model.Threshold;
import org.eclipse.chemclipse.chromatogram.peak.detector.settings.IPeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.BasePeakDetector;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.PeakDetectorSettingsMSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlope;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.IFirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.NoiseSegment;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.PeakBuilderMSD;
import org.eclipse.chemclipse.msd.model.xic.TotalIonSignalExtractor;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PeakDetectorMSD
extends BasePeakDetector
implements IPeakDetectorMSD {
    private static final Logger logger = Logger.getLogger(PeakDetectorMSD.class);
    private static final String DETECTOR_DESCRIPTION = "Peak Detector First Derivative";
    private IPeakDetectorSettingsMSD peakDetectorSettings;

    public IProcessingInfo detect(IChromatogramSelectionMSD chromatogramSelection, IPeakDetectorSettingsMSD detectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate((IChromatogramSelection)chromatogramSelection, (IPeakDetectorSettings)detectorSettings, monitor);
        if (!processingInfo.hasErrorMessages()) {
            if (detectorSettings instanceof PeakDetectorSettingsMSD) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                PeakDetectorSettingsMSD peakDetectorSettings = (PeakDetectorSettingsMSD)detectorSettings;
                IChromatogramMSD chromatogram = (IChromatogramMSD)chromatogramSelection.getChromatogram();
                List noiseSegments = null;
                if (peakDetectorSettings.isUseNoiseSegments()) {
                    noiseSegments = NoiseChromatogramClassifier.getNoiseSegments((IChromatogram)chromatogram, (IScanRange)chromatogramSelection, (boolean)false, (IProgressMonitor)subMonitor.split(10));
                }
                List<IChromatogramPeakMSD> peaks = this.detectPeaks(chromatogramSelection, peakDetectorSettings, noiseSegments, (IProgressMonitor)subMonitor.split(90));
                for (IChromatogramPeakMSD peak : peaks) {
                    chromatogram.addPeak((IPeak)peak);
                }
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DETECTOR_DESCRIPTION, String.valueOf(peaks.size()) + " peak(s) have been detected."));
            } else {
                logger.warn((Object)("Settings is not of type: " + PeakDetectorSettingsMSD.class));
            }
        }
        return processingInfo;
    }

    public IPeakDetectorSettingsMSD getPeakDetectorSettings() {
        return this.peakDetectorSettings;
    }

    public PeakDetectorMSD setPeakDetectorSettings(IPeakDetectorSettingsMSD peakDetectorSettings) {
        this.peakDetectorSettings = peakDetectorSettings;
        return this;
    }

    public IProcessingInfo detect(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        if (this.peakDetectorSettings == null) {
            this.peakDetectorSettings = PreferenceSupplier.getPeakDetectorSettingsMSD();
        }
        return this.detect(chromatogramSelection, this.peakDetectorSettings, monitor);
    }

    public List<IChromatogramPeakMSD> detectPeaks(IChromatogramSelectionMSD chromatogramSelection, PeakDetectorSettingsMSD peakDetectorSettings, IProgressMonitor monitor) {
        return this.detectPeaks(chromatogramSelection, peakDetectorSettings, null, monitor);
    }

    public List<IChromatogramPeakMSD> detectPeaks(IChromatogramSelectionMSD chromatogramSelection, PeakDetectorSettingsMSD peakDetectorSettings, List<NoiseSegment> noiseSegments, IProgressMonitor monitor) {
        ArrayList<IChromatogramPeakMSD> extractPeaks = new ArrayList<IChromatogramPeakMSD>();
        Collection<IMarkedIons> filterIons = peakDetectorSettings.getFilterIons();
        for (IMarkedIons ions : filterIons) {
            Threshold threshold = peakDetectorSettings.getThreshold();
            WindowSize windowSize = peakDetectorSettings.getMovingAverageWindowSize();
            ArrayList<IRawPeak> rawPeaks = new ArrayList<IRawPeak>();
            if (noiseSegments != null && noiseSegments.size() > 0) {
                IFirstDerivativeDetectorSlopes slopes;
                NoiseSegment noiseSegment;
                Iterator<NoiseSegment> iterator = noiseSegments.iterator();
                int startRetentionTime = chromatogramSelection.getStartRetentionTime();
                int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
                NoiseSegment noiseSegment2 = noiseSegment = iterator.hasNext() ? iterator.next() : null;
                if (noiseSegment != null) {
                    chromatogramSelection.setRangeRetentionTime(startRetentionTime, noiseSegment.getStartRetentionTime());
                    slopes = PeakDetectorMSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize, ions);
                    rawPeaks.addAll(PeakDetectorMSD.getRawPeaks(slopes, threshold, monitor));
                }
                while (iterator.hasNext()) {
                    int startRetentionTimeSegment = noiseSegment.getStopRetentionTime();
                    noiseSegment = iterator.next();
                    int stopRetentionTimeSegment = noiseSegment.getStartRetentionTime();
                    chromatogramSelection.setRangeRetentionTime(startRetentionTimeSegment, stopRetentionTimeSegment);
                    IFirstDerivativeDetectorSlopes slopes2 = PeakDetectorMSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize, ions);
                    rawPeaks.addAll(PeakDetectorMSD.getRawPeaks(slopes2, threshold, monitor));
                }
                if (noiseSegment != null) {
                    chromatogramSelection.setRangeRetentionTime(noiseSegment.getStopRetentionTime(), stopRetentionTime);
                    slopes = PeakDetectorMSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize, ions);
                    rawPeaks.addAll(PeakDetectorMSD.getRawPeaks(slopes, threshold, monitor));
                }
                chromatogramSelection.setRangeRetentionTime(startRetentionTime, stopRetentionTime);
            } else {
                IFirstDerivativeDetectorSlopes slopes = PeakDetectorMSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize, ions);
                rawPeaks.addAll(PeakDetectorMSD.getRawPeaks(slopes, threshold, monitor));
            }
            List<IChromatogramPeakMSD> peaks = this.extractPeaks(rawPeaks, (IChromatogramMSD)chromatogramSelection.getChromatogram(), peakDetectorSettings, ions);
            if (peakDetectorSettings.isUseIndividualTraces()) {
                String classifier = "Trace " + ions.getIonsNominal().iterator().next();
                for (IChromatogramPeakMSD msd : peaks) {
                    msd.addClassifier(classifier);
                }
            }
            extractPeaks.addAll(peaks);
        }
        return extractPeaks;
    }

    private List<IChromatogramPeakMSD> extractPeaks(List<IRawPeak> rawPeaks, IChromatogramMSD chromatogram, PeakDetectorSettingsMSD peakDetectorSettings, IMarkedIons ions) {
        ArrayList<IChromatogramPeakMSD> peaks = new ArrayList<IChromatogramPeakMSD>();
        Set traces = ions.getIonsNominal().stream().map(e -> (int)e).collect(Collectors.toSet());
        boolean includeBackground = peakDetectorSettings.isIncludeBackground();
        boolean optimizeBaseline = peakDetectorSettings.isOptimizeBaseline();
        for (IRawPeak rawPeak : rawPeaks) {
            try {
                IChromatogramPeakMSD peak;
                ScanRange scanRange = new ScanRange(rawPeak.getStartScan(), rawPeak.getStopScan());
                if (includeBackground && optimizeBaseline) {
                    scanRange = this.optimizeBaseline((IChromatogram<? extends IPeak>)chromatogram, scanRange.getStartScan(), rawPeak.getMaximumScan(), scanRange.getStopScan(), ions);
                }
                if (!this.isValidPeak(peak = PeakBuilderMSD.createPeak((IChromatogramMSD)chromatogram, (IScanRange)scanRange, (boolean)includeBackground, traces, (IMarkedIons.IonMarkMode)ions.getMode()), peakDetectorSettings)) continue;
                peak.setDetectorDescription(DETECTOR_DESCRIPTION);
                peaks.add(peak);
            }
            catch (Exception e2) {
                logger.debug((Object)e2.getLocalizedMessage());
            }
        }
        return peaks;
    }

    public static IFirstDerivativeDetectorSlopes getFirstDerivativeSlopes(IChromatogramSelectionMSD chromatogramSelection, WindowSize movingAverageWindowSize, IMarkedIons filterIons) {
        IChromatogramMSD chromatogram = (IChromatogramMSD)chromatogramSelection.getChromatogram();
        try {
            TotalIonSignalExtractor totalIonSignalExtractor = new TotalIonSignalExtractor(chromatogram);
            ITotalScanSignals signals = totalIonSignalExtractor.getTotalIonSignals(chromatogramSelection, filterIons);
            TotalScanSignalsModifier.normalize((ITotalScanSignals)signals, (float)100000.0f);
            int startScan = signals.getStartScan();
            int stopScan = signals.getStopScan();
            FirstDerivativeDetectorSlopes slopes = new FirstDerivativeDetectorSlopes(signals);
            int scan = startScan;
            while (scan < stopScan) {
                ITotalScanSignal s1 = signals.getTotalScanSignal(scan);
                ITotalScanSignal s2 = signals.getNextTotalScanSignal(scan);
                if (s1 != null && s2 != null) {
                    Point p1 = new Point((double)s1.getRetentionTime(), (double)s1.getTotalSignal());
                    Point p2 = new Point((double)s2.getRetentionTime(), (double)s2.getTotalSignal());
                    FirstDerivativeDetectorSlope slope = new FirstDerivativeDetectorSlope((IPoint)p1, (IPoint)p2, s1.getRetentionTime());
                    slopes.add(slope);
                }
                ++scan;
            }
            slopes.calculateMovingAverage(movingAverageWindowSize);
            return slopes;
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    static IMarkedIons getIonFilter(Collection<Number> filterIons, FilterMode mode) {
        return new MarkedIons(PeakDetectorMSD.buildIons(filterIons), PeakDetectorMSD.buildFilterMode(mode));
    }

    private static int[] buildIons(Collection<Number> filterIons) {
        int[] result = new int[filterIons.size()];
        int cnt = 0;
        Iterator<Number> it = filterIons.iterator();
        while (it.hasNext()) {
            result[cnt++] = it.next().intValue();
        }
        return result;
    }

    private static IMarkedIons.IonMarkMode buildFilterMode(FilterMode mode) {
        switch (mode) {
            case EXCLUDE: {
                return IMarkedIons.IonMarkMode.EXCLUDE;
            }
            case INCLUDE: {
                return IMarkedIons.IonMarkMode.INCLUDE;
            }
        }
        throw new IllegalArgumentException("Unknown mode " + mode);
    }

    private boolean isValidPeak(IChromatogramPeakMSD peak, PeakDetectorSettingsMSD peakDetectorSettings) {
        return peak != null && peak.getSignalToNoiseRatio() >= peakDetectorSettings.getMinimumSignalToNoiseRatio();
    }
}

