/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.BasePeakDetector;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.PeakDetectorCSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.PeakDetectorMSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.PeakDetectorWSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.FirstDerivativePeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.IFirstDerivativeDetectorSlope;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.IFirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.core.ISignal;
import org.eclipse.chemclipse.model.core.PeakList;
import org.eclipse.chemclipse.model.detector.IMeasurementPeakDetector;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.nmr.model.core.SpectrumMeasurement;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.detector.Detector;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IMeasurementPeakDetector.class, Detector.class})
public class FirstDerivativePeakDetector
implements IMeasurementPeakDetector<FirstDerivativePeakDetectorSettings> {
    public String getName() {
        return "First Derivative Peak Detector";
    }

    public Class<FirstDerivativePeakDetectorSettings> getConfigClass() {
        return FirstDerivativePeakDetectorSettings.class;
    }

    public <T extends IMeasurement> Map<T, PeakList> detectIMeasurementPeaks(Collection<T> detectorInputItems, FirstDerivativePeakDetectorSettings globalConfiguration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        LinkedHashMap<IMeasurement, PeakList> result = new LinkedHashMap<IMeasurement, PeakList>();
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)(detectorInputItems.size() * 100));
        for (IMeasurement measurement : detectorInputItems) {
            IFirstDerivativeDetectorSlopes slopes;
            FirstDerivativePeakDetectorSettings configuration;
            if (measurement instanceof IChromatogramMSD) {
                configuration = globalConfiguration == null ? new FirstDerivativePeakDetectorSettings(DataType.MSD) : globalConfiguration;
                Collection<IMarkedIons> markedIons = globalConfiguration.getFilterIons();
                slopes = PeakDetectorMSD.getFirstDerivativeSlopes((IChromatogramSelectionMSD)new ChromatogramSelectionMSD((IChromatogramMSD)measurement), configuration.getMovingAverageWindowSize(), markedIons.iterator().next());
            } else if (measurement instanceof IChromatogramCSD) {
                configuration = globalConfiguration == null ? new FirstDerivativePeakDetectorSettings(DataType.CSD) : globalConfiguration;
                slopes = PeakDetectorCSD.getFirstDerivativeSlopes((IChromatogramSelectionCSD)new ChromatogramSelectionCSD((IChromatogramCSD)measurement), configuration.getMovingAverageWindowSize());
            } else if (measurement instanceof IChromatogramWSD) {
                configuration = globalConfiguration == null ? new FirstDerivativePeakDetectorSettings(DataType.WSD) : globalConfiguration;
                slopes = PeakDetectorWSD.getFirstDerivativeSlopes((IChromatogramSelectionWSD)new ChromatogramSelectionWSD((IChromatogramWSD)measurement), configuration.getMovingAverageWindowSize());
            } else if (measurement instanceof SpectrumMeasurement) {
                configuration = globalConfiguration == null ? new FirstDerivativePeakDetectorSettings(DataType.NMR) : globalConfiguration;
                slopes = FirstDerivativePeakDetector.getSignalSlopes(((SpectrumMeasurement)measurement).getSignals(), configuration.getMovingAverageWindowSize());
            } else {
                throw new IllegalArgumentException();
            }
            List<IRawPeak> rawPeaks = BasePeakDetector.getRawPeaks(slopes, configuration.getThreshold(), (IProgressMonitor)convert.split(100));
            result.put(measurement, new PeakList(Collections.unmodifiableCollection(rawPeaks), this.getID(), this.getName(), this.getDescription()));
        }
        return result;
    }

    public String getDescription() {
        return "Implementation of a first derivative peak detector.";
    }

    private static IFirstDerivativeDetectorSlopes getSignalSlopes(List<? extends ISignal> signals, WindowSize windowSize) {
        FirstDerivativeDetectorSlopes firstDerivativeSlopes = new FirstDerivativeDetectorSlopes(signals);
        int i = 1;
        while (i < signals.size()) {
            ISignal signal = signals.get(i - 1);
            ISignal signalNext = signals.get(i);
            SignalSlope slope = new SignalSlope(signal, signalNext);
            firstDerivativeSlopes.add(slope);
            ++i;
        }
        firstDerivativeSlopes.calculateMovingAverage(windowSize);
        return firstDerivativeSlopes;
    }

    public boolean acceptsIMeasurements(Collection<? extends IMeasurement> items) {
        for (IMeasurement iMeasurement : items) {
            if (this.canProcess(iMeasurement)) continue;
            return false;
        }
        return true;
    }

    private boolean canProcess(IMeasurement measurement) {
        if (measurement instanceof IChromatogramMSD) {
            return true;
        }
        if (measurement instanceof IChromatogramWSD) {
            return true;
        }
        if (measurement instanceof IChromatogramCSD) {
            return true;
        }
        return measurement instanceof SpectrumMeasurement;
    }

    private static final class SignalSlope
    implements IFirstDerivativeDetectorSlope {
        private double slope;

        public SignalSlope(ISignal signal, ISignal signalNext) {
            Point p1 = new Point(signal.getX(), signal.getY());
            Point p2 = new Point(signalNext.getX(), signalNext.getY());
            this.slope = Equations.calculateSlopeAbs((IPoint)p1, (IPoint)p2);
        }

        public void setSlope(double slope) {
            this.slope = slope;
        }

        public double getSlope() {
            return this.slope;
        }

        public int getRetentionTime() {
            return -1;
        }

        public String getDrift() {
            return "";
        }
    }
}

