/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.IPeakDetectorCSD;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.settings.IPeakDetectorSettingsCSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.model.Threshold;
import org.eclipse.chemclipse.chromatogram.peak.detector.settings.IPeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.BasePeakDetector;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.PeakDetectorSettingsCSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlope;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.IFirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.support.PeakBuilderCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.NoiseSegment;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PeakDetectorCSD
extends BasePeakDetector
implements IPeakDetectorCSD {
    private static final Logger logger = Logger.getLogger(PeakDetectorCSD.class);
    private static final String DETECTOR_DESCRIPTION = "Peak Detector First Derivative";

    public IProcessingInfo detect(IChromatogramSelectionCSD chromatogramSelection, IPeakDetectorSettingsCSD detectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate((IChromatogramSelection)chromatogramSelection, (IPeakDetectorSettings)detectorSettings, monitor);
        if (!processingInfo.hasErrorMessages()) {
            if (detectorSettings instanceof PeakDetectorSettingsCSD) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                PeakDetectorSettingsCSD peakDetectorSettings = (PeakDetectorSettingsCSD)detectorSettings;
                IChromatogramCSD chromatogram = (IChromatogramCSD)chromatogramSelection.getChromatogram();
                List noiseSegments = null;
                if (peakDetectorSettings.isUseNoiseSegments()) {
                    noiseSegments = NoiseChromatogramClassifier.getNoiseSegments((IChromatogram)chromatogram, (IScanRange)chromatogramSelection, (boolean)false, (IProgressMonitor)subMonitor.split(10));
                }
                List<IChromatogramPeakCSD> peaks = this.detectPeaks(chromatogramSelection, peakDetectorSettings, noiseSegments, (IProgressMonitor)subMonitor.split(90));
                for (IChromatogramPeakCSD peak : peaks) {
                    chromatogram.addPeak((IPeak)peak);
                }
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DETECTOR_DESCRIPTION, "Peaks have been detected successfully."));
            } else {
                logger.warn((Object)("Settings is not of type: " + PeakDetectorSettingsCSD.class));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo detect(IChromatogramSelectionCSD chromatogramSelection, IProgressMonitor monitor) {
        PeakDetectorSettingsCSD peakDetectorSettings = PreferenceSupplier.getPeakDetectorSettingsCSD();
        return this.detect(chromatogramSelection, (IPeakDetectorSettingsCSD)peakDetectorSettings, monitor);
    }

    public List<IChromatogramPeakCSD> detectPeaks(IChromatogramSelectionCSD chromatogramSelection, PeakDetectorSettingsCSD peakDetectorSettings, IProgressMonitor monitor) {
        return this.detectPeaks(chromatogramSelection, peakDetectorSettings, null, monitor);
    }

    public List<IChromatogramPeakCSD> detectPeaks(IChromatogramSelectionCSD chromatogramSelection, PeakDetectorSettingsCSD peakDetectorSettings, List<NoiseSegment> noiseSegments, IProgressMonitor monitor) {
        Threshold threshold = peakDetectorSettings.getThreshold();
        WindowSize windowSize = peakDetectorSettings.getMovingAverageWindowSize();
        ArrayList<IRawPeak> rawPeaks = new ArrayList<IRawPeak>();
        if (noiseSegments != null && noiseSegments.size() > 0) {
            IFirstDerivativeDetectorSlopes slopes;
            NoiseSegment noiseSegment;
            Iterator<NoiseSegment> iterator = noiseSegments.iterator();
            int startRetentionTime = chromatogramSelection.getStartRetentionTime();
            int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
            NoiseSegment noiseSegment2 = noiseSegment = iterator.hasNext() ? iterator.next() : null;
            if (noiseSegment != null) {
                chromatogramSelection.setRangeRetentionTime(startRetentionTime, noiseSegment.getStartRetentionTime());
                slopes = PeakDetectorCSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize);
                rawPeaks.addAll(PeakDetectorCSD.getRawPeaks(slopes, threshold, monitor));
            }
            while (iterator.hasNext()) {
                int startRetentionTimeSegment = noiseSegment.getStopRetentionTime();
                noiseSegment = iterator.next();
                int stopRetentionTimeSegment = noiseSegment.getStartRetentionTime();
                chromatogramSelection.setRangeRetentionTime(startRetentionTimeSegment, stopRetentionTimeSegment);
                IFirstDerivativeDetectorSlopes slopes2 = PeakDetectorCSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize);
                rawPeaks.addAll(PeakDetectorCSD.getRawPeaks(slopes2, threshold, monitor));
            }
            if (noiseSegment != null) {
                chromatogramSelection.setRangeRetentionTime(noiseSegment.getStopRetentionTime(), stopRetentionTime);
                slopes = PeakDetectorCSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize);
                rawPeaks.addAll(PeakDetectorCSD.getRawPeaks(slopes, threshold, monitor));
            }
            chromatogramSelection.setRangeRetentionTime(startRetentionTime, stopRetentionTime);
        } else {
            IFirstDerivativeDetectorSlopes slopes = PeakDetectorCSD.getFirstDerivativeSlopes(chromatogramSelection, windowSize);
            rawPeaks.addAll(PeakDetectorCSD.getRawPeaks(slopes, threshold, monitor));
        }
        return this.extractPeaks(rawPeaks, (IChromatogramCSD)chromatogramSelection.getChromatogram(), peakDetectorSettings);
    }

    private List<IChromatogramPeakCSD> extractPeaks(List<IRawPeak> rawPeaks, IChromatogramCSD chromatogram, PeakDetectorSettingsCSD peakDetectorSettings) {
        ArrayList<IChromatogramPeakCSD> peaks = new ArrayList<IChromatogramPeakCSD>();
        boolean includeBackground = peakDetectorSettings.isIncludeBackground();
        boolean optimizeBaseline = peakDetectorSettings.isOptimizeBaseline();
        for (IRawPeak rawPeak : rawPeaks) {
            try {
                IChromatogramPeakCSD peak;
                ScanRange scanRange = new ScanRange(rawPeak.getStartScan(), rawPeak.getStopScan());
                if (includeBackground && optimizeBaseline) {
                    scanRange = this.optimizeBaseline((IChromatogram<? extends IPeak>)chromatogram, scanRange.getStartScan(), rawPeak.getMaximumScan(), scanRange.getStopScan(), null);
                }
                if (!this.isValidPeak(peak = PeakBuilderCSD.createPeak((IChromatogramCSD)chromatogram, (IScanRange)scanRange, (boolean)peakDetectorSettings.isIncludeBackground()), peakDetectorSettings)) continue;
                peak.setDetectorDescription(DETECTOR_DESCRIPTION);
                peaks.add(peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        }
        return peaks;
    }

    public static IFirstDerivativeDetectorSlopes getFirstDerivativeSlopes(IChromatogramSelectionCSD chromatogramSelection, WindowSize window) {
        TotalScanSignals signals = new TotalScanSignals((IChromatogramSelection)chromatogramSelection);
        TotalScanSignalsModifier.normalize((ITotalScanSignals)signals, (float)100000.0f);
        FirstDerivativeDetectorSlopes slopes = new FirstDerivativeDetectorSlopes((ITotalScanSignals)signals);
        int startScan = signals.getStartScan();
        int stopScan = signals.getStopScan();
        int scan = startScan;
        while (scan < stopScan) {
            ITotalScanSignal s1 = signals.getTotalScanSignal(scan);
            ITotalScanSignal s2 = signals.getNextTotalScanSignal(scan);
            if (s1 != null && s2 != null) {
                Point p1 = new Point((double)s1.getRetentionTime(), (double)s1.getTotalSignal());
                Point p2 = new Point((double)s2.getRetentionTime(), (double)s2.getTotalSignal());
                FirstDerivativeDetectorSlope slope = new FirstDerivativeDetectorSlope((IPoint)p1, (IPoint)p2, s1.getRetentionTime());
                slopes.add(slope);
            }
            ++scan;
        }
        slopes.calculateMovingAverage(window);
        return slopes;
    }

    private boolean isValidPeak(IChromatogramPeakCSD peak, PeakDetectorSettingsCSD peakDetectorSettings) {
        return peak != null && peak.getSignalToNoiseRatio() >= peakDetectorSettings.getMinimumSignalToNoiseRatio();
    }
}

