/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider;

import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Feature;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class FeatureLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String VARIABLE = "Variable";
    public static final String USE = "Use";
    public static final String CLASSIFICATION = "Classification";
    public static final String DESCRIPTION = "Description";
    public static final int BOUND_SAMPLE = 100;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0000");
    public static String[] TITLES = new String[]{"Variable", "Use", "Classification", "Description"};
    public static int[] BOUNDS = new int[]{100, 30, 150, 200};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        if (columnIndex == 1 && element instanceof Feature) {
            Feature feature = (Feature)element;
            IVariable variable = feature.getVariable();
            if (variable.isSelected()) {
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selected.gif", "16x16");
            }
            return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/deselected.gif", "16x16");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof Feature) {
            Feature feature = (Feature)element;
            IVariable variable = feature.getVariable();
            switch (columnIndex) {
                case 0: {
                    text = variable.getValue();
                    break;
                }
                case 1: {
                    text = "";
                    break;
                }
                case 2: {
                    text = variable.getClassification();
                    break;
                }
                case 3: {
                    text = variable.getDescription();
                    break;
                }
                default: {
                    double value;
                    int index = columnIndex - 4;
                    List sampleData = feature.getSampleData();
                    text = sampleData.size() > index ? (Double.isNaN(value = ((ISampleData)sampleData.get(index)).getData()) ? "NaN" : this.decimalFormat.format(value)) : "--";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/sample.gif", "16x16");
    }
}

