/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AbstractFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AnovaFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.IFilterWizardPage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FilterAnovaWizardPage
extends WizardPage
implements IFilterWizardPage {
    private final DataBindingContext dbc = new DataBindingContext();
    private IObservableValue<Double> observeAlfa;
    private IObservableValue<IFilter.DataTypeProcessing> dataTypeFiltration;

    protected FilterAnovaWizardPage(AnovaFilter anovaFilter) {
        super("ANOVA Filter");
        this.setTitle("One-way Analysis of Variance Filter");
        this.setDescription("ANOVA filter works just with selected sampels, which are in group (contains group name)");
        this.observeAlfa = PojoProperties.value(AnovaFilter.class, (String)"alpha", Double.class).observe((Object)anovaFilter);
        this.dataTypeFiltration = PojoProperties.value(AbstractFilter.class, (String)"dataTypeProcessing", IFilter.DataTypeProcessing.class).observe((Object)anovaFilter);
    }

    public void createControl(Composite parent) {
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(composite, 0);
        label.setText("Select data type filtration");
        SelectObservableValue selectedRadioButtonObservableProcessData = new SelectObservableValue();
        Button button = new Button(composite, 16);
        button.setText("Use on raw data");
        selectedRadioButtonObservableProcessData.addOption((Object)IFilter.DataTypeProcessing.RAW_DATA, (IObservableValue)WidgetProperties.selection().observe((Widget)button));
        button = new Button(composite, 16);
        button.setText("Use on modified data");
        selectedRadioButtonObservableProcessData.addOption((Object)IFilter.DataTypeProcessing.MODIFIED_DATA, (IObservableValue)WidgetProperties.selection().observe((Widget)button));
        this.dbc.bindValue((IObservableValue)selectedRadioButtonObservableProcessData, this.dataTypeFiltration, new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT), null);
        label = new Label(composite, 0);
        label.setText("Select row in data table whose p-value is less than value (in %)");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        Text text = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        ISWTObservableValue targetObservableValue = WidgetProperties.text((int)24).observe((Widget)text);
        UpdateValueStrategy targetToModel = new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT);
        targetToModel.setConverter(IConverter.create(String.class, Double.class, o1 -> {
            try {
                return Double.parseDouble((String)o1) / 100.0;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }));
        targetToModel.setAfterConvertValidator(o1 -> {
            Double d;
            if (o1 instanceof Double && (d = (Double)o1) <= 1.0 && d >= 0.0) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)"error");
        });
        UpdateValueStrategy modelToTarget = UpdateValueStrategy.create((IConverter)IConverter.create(Double.class, String.class, o1 -> Double.toString((Double)o1 * 100.0)));
        this.dbc.bindValue((IObservableValue)targetObservableValue, this.observeAlfa, targetToModel, modelToTarget);
        this.setControl((Control)composite);
    }

    @Override
    public void update() {
        this.dbc.updateModels();
    }
}

