/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.IInputWizard;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.support.InputFilesTable;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GroupNamesWizardPage
extends WizardPage {
    private final int CONTAINS_STRING = 0;
    private final int STARTS_WITH_STRING = 1;
    private final int ENDS_WITH_STRING = 2;
    private final int REGEXP = 3;
    private int selectNames = 0;
    private InputFilesTable inputFilesTable;
    private Text textGroupName;
    private Button caseSensitive;
    private Text textSelectNames;

    public GroupNamesWizardPage() {
        super("Sample Grouping");
        this.setTitle("Set Group Name");
        this.setDescription("Set mass group name according to name");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createLabel(composite, "Group Name");
        this.textGroupName = this.createText(composite);
        this.createLabel(composite, "String or regular expression to match the group name(s)");
        this.textSelectNames = this.createText(composite);
        this.createOptionGroup(composite);
        this.createToolbar(composite);
        this.inputFilesTable = this.createInputFilesTable(composite);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IInputWizard inputWizard = (IInputWizard)this.getWizard();
            this.inputFilesTable.setDataInputEntries(inputWizard.getDataInputEntries());
            this.inputFilesTable.update();
        }
        super.setVisible(visible);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(256));
        label.setText(text);
        return label;
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void createOptionGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Settings");
        this.caseSensitive = this.createCheckBox((Composite)group, "Case Sensitive");
        this.createRadioButton((Composite)group, "Contains String", true, 0);
        this.createRadioButton((Composite)group, "Starts with String", false, 1);
        this.createRadioButton((Composite)group, "Ends with String", false, 2);
        this.createRadioButton((Composite)group, "Regular Expression", false, 3);
    }

    private InputFilesTable createInputFilesTable(Composite parent) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        gridData.heightHint = 300;
        this.inputFilesTable = new InputFilesTable(parent, gridData);
        IInputWizard inputWizard = (IInputWizard)this.getWizard();
        this.inputFilesTable.setDataInputEntries(inputWizard.getDataInputEntries());
        return this.inputFilesTable;
    }

    private void createToolbar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createButtonProcess(composite);
        this.createButtonReset(composite);
    }

    private Button createButtonProcess(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Set the group name(s)");
        button.setText("Set the group name(s)");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupNamesWizardPage.this.updateGroupNames();
            }
        });
        return button;
    }

    private Button createCheckBox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    private Button createRadioButton(Composite parent, String text, boolean selected, final int option) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setSelection(selected);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupNamesWizardPage.this.selectNames = option;
            }
        });
        return button;
    }

    private Button createButtonReset(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the group name(s)");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupNamesWizardPage.this.resetGroupNames();
            }
        });
        return button;
    }

    private void updateGroupNames() {
        String s = this.textSelectNames.getText().trim();
        if (s.isEmpty()) {
            return;
        }
        ArrayList filterInput = new ArrayList();
        IInputWizard inputWizard = (IInputWizard)this.getWizard();
        switch (this.selectNames) {
            case 0: {
                if (!this.caseSensitive.getSelection()) {
                    inputWizard.getDataInputEntries().stream().filter(i -> i.getName().toLowerCase().contains(s.toLowerCase())).forEach(filterInput::add);
                    break;
                }
                inputWizard.getDataInputEntries().stream().filter(i -> i.getName().contains(s)).forEach(filterInput::add);
                break;
            }
            case 1: {
                if (!this.caseSensitive.getSelection()) {
                    inputWizard.getDataInputEntries().stream().filter(i -> i.getName().toLowerCase().startsWith(s.toLowerCase())).forEach(filterInput::add);
                    break;
                }
                inputWizard.getDataInputEntries().stream().filter(i -> i.getName().startsWith(s)).forEach(filterInput::add);
                break;
            }
            case 2: {
                if (!this.caseSensitive.getSelection()) {
                    inputWizard.getDataInputEntries().stream().filter(i -> i.getName().toLowerCase().endsWith(s.toLowerCase())).forEach(filterInput::add);
                    break;
                }
                inputWizard.getDataInputEntries().stream().filter(i -> i.getName().endsWith(s)).forEach(filterInput::add);
                break;
            }
            case 3: {
                Pattern p = Pattern.compile(s);
                inputWizard.getDataInputEntries().stream().filter(i -> p.matcher(i.getName()).find()).forEach(filterInput::add);
                break;
            }
        }
        String groupName = this.textGroupName.getText().trim();
        String setGroupName = groupName.isEmpty() ? null : groupName;
        filterInput.forEach(i -> i.setGroupName(setGroupName));
        this.update();
    }

    private void resetGroupNames() {
        IInputWizard inputWizard = (IInputWizard)this.getWizard();
        for (IDataInputEntry dataInputEntry : inputWizard.getDataInputEntries()) {
            dataInputEntry.setGroupName("");
        }
        this.update();
    }

    private void update() {
        this.inputFilesTable.update();
    }
}

