/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt.ISelectionListenerPCs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class PrincipalComponentUI
extends Composite {
    public static final int SPINNER_NONE = 0;
    public static final int SPINNER_X = 1;
    public static final int SPINNER_Y = 2;
    public static final int SPINNER_Z = 4;
    private int options = 0;
    int maximum = 3;
    private Spinner spinnerX;
    private Spinner spinnerY;
    private Spinner spinnerZ;
    private ISelectionListenerPCs selectionListener = null;

    public PrincipalComponentUI(Composite parent, int style) {
        this(parent, style, 7);
    }

    public PrincipalComponentUI(Composite parent, int style, int options) {
        super(parent, style);
        this.options = options;
        this.createControl();
    }

    public void setSelectionListener(ISelectionListenerPCs selectionListener) {
        this.selectionListener = selectionListener;
    }

    public int getPCX() {
        return this.spinnerX.getSelection();
    }

    public int getPCY() {
        return this.spinnerY.getSelection();
    }

    public int getPCZ() {
        return this.spinnerZ.getSelection();
    }

    public void setInput(IAnalysisSettings analysisSettings) {
        if (analysisSettings != null) {
            int numberPrincipalComponents = analysisSettings.getNumberOfPrincipalComponents();
            int selectionX = this.spinnerX.getSelection();
            this.spinnerX.setSelection(selectionX <= numberPrincipalComponents ? selectionX : 1);
            this.spinnerX.setMaximum(numberPrincipalComponents);
            this.spinnerX.setEnabled(this.isSpinnerActive(1));
            int selectionY = this.spinnerY.getSelection();
            this.spinnerY.setSelection(selectionY <= numberPrincipalComponents ? selectionY : 1);
            this.spinnerY.setMaximum(numberPrincipalComponents);
            this.spinnerY.setEnabled(this.isSpinnerActive(2));
            int selectionZ = this.spinnerZ.getSelection();
            this.spinnerZ.setSelection(selectionZ <= numberPrincipalComponents ? selectionZ : 1);
            this.spinnerZ.setMaximum(numberPrincipalComponents);
            this.spinnerZ.setEnabled(this.isSpinnerActive(4));
        } else {
            this.spinnerX.setSelection(1);
            this.spinnerX.setMaximum(this.maximum);
            this.spinnerX.setEnabled(false);
            this.spinnerY.setSelection(2);
            this.spinnerY.setMaximum(this.maximum);
            this.spinnerY.setEnabled(false);
            this.spinnerZ.setSelection(3);
            this.spinnerZ.setMaximum(this.maximum);
            this.spinnerZ.setEnabled(false);
        }
    }

    private void createControl() {
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.setLayout((Layout)gridLayout);
        this.createLabel(this, "PC (X):");
        this.spinnerX = this.createSpinner(this, "Select the PC for the x axis.", this.maximum, this.isSpinnerActive(1), 1);
        this.createLabel(this, "PC (Y):");
        this.spinnerY = this.createSpinner(this, "Select the PC for the y axis.", this.maximum, this.isSpinnerActive(2), 2);
        this.createLabel(this, "PC (Z):");
        this.spinnerZ = this.createSpinner(this, "Select the PC for the z axis.", this.maximum, this.isSpinnerActive(4), 3);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private Spinner createSpinner(Composite parent, String tooltip, int maximum, boolean enabled, int selection) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setToolTipText(tooltip);
        spinner.setMinimum(1);
        spinner.setIncrement(1);
        spinner.setSelection(selection);
        spinner.setMaximum(maximum);
        spinner.setEnabled(enabled);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrincipalComponentUI.this.fireUpdate();
            }
        });
        return spinner;
    }

    private boolean isSpinnerActive(int constant) {
        return (this.options & constant) == constant;
    }

    private void fireUpdate() {
        if (this.selectionListener != null) {
            this.selectionListener.update(this.spinnerX.getSelection(), this.spinnerY.getSelection(), this.spinnerZ.getSelection());
        }
    }
}

