/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.PeakSampleData;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Sample;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition_F64;

public class PcaUtils {
    public static <V extends IVariable, S extends ISample> Map<String, double[]> extractData(ISamples<V, S> samples) {
        HashMap<String, double[]> selectedSamples = new HashMap<String, double[]>();
        List variables = samples.getVariables();
        int numSelected = (int)variables.stream().filter(r -> r.isSelected()).count();
        for (ISample sample : samples.getSampleList()) {
            double[] selectedSampleData = null;
            if (!sample.isSelected()) continue;
            List data = sample.getSampleData();
            selectedSampleData = new double[numSelected];
            int j = 0;
            int i = 0;
            while (i < data.size()) {
                if (((IVariable)variables.get(i)).isSelected()) {
                    selectedSampleData[j] = ((ISampleData)data.get(i)).getModifiedData();
                    ++j;
                }
                ++i;
            }
            selectedSamples.put(sample.getName(), selectedSampleData);
        }
        return selectedSamples;
    }

    public static <V extends IVariable, S extends ISample> RealMatrix getCovarianceMatrix(ISamples<V, S> samples) {
        Map<String, double[]> data = PcaUtils.extractData(samples);
        double[][] array = new double[data.size()][];
        Iterator<double[]> it = data.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            double[] ds = it.next();
            array[i] = ds;
            ++i;
        }
        Covariance covariance = new Covariance((double[][])array);
        return covariance.getCovarianceMatrix();
    }

    public static <V extends IVariable, S extends ISample> double[] getEigenValuesCovarianceMatrix(ISamples<V, S> samples) {
        RealMatrix covarianceMatrix = PcaUtils.getCovarianceMatrix(samples);
        EigenDecomposition_F64 eigenDecomposition = DecompositionFactory_DDRM.eig((int)covarianceMatrix.getColumnDimension(), (boolean)false, (boolean)true);
        eigenDecomposition.decompose((Matrix)new DMatrixRMaj(covarianceMatrix.getData()));
        double[] eigenvalues = new double[eigenDecomposition.getNumberOfEigenvalues()];
        int i = 0;
        while (i < eigenvalues.length) {
            eigenvalues[i] = eigenDecomposition.getEigenvalue((int)i).real;
            ++i;
        }
        return eigenvalues;
    }

    public static Set<String> getGroupNames(List<IResultPCA> pcaResults) {
        HashSet<String> groupNames = new HashSet<String>();
        for (IResultPCA pcaResult : pcaResults) {
            String groupName = pcaResult.getGroupName();
            groupNames.add(groupName);
        }
        return groupNames;
    }

    public static <S extends ISample> Set<String> getGroupNames(List<S> samples, boolean onlySelected) {
        HashSet<String> groupNames = new HashSet<String>();
        for (ISample sample : samples) {
            String groupName = sample.getGroupName();
            if (onlySelected && !sample.isSelected()) continue;
            groupNames.add(groupName);
        }
        return groupNames;
    }

    public static Set<String> getGroupNamesFromEntry(List<IDataInputEntry> inputEntries) {
        HashSet<String> groupNames = new HashSet<String>();
        for (IDataInputEntry inputEntry : inputEntries) {
            String groupName = inputEntry.getGroupName();
            groupNames.add(groupName);
        }
        return groupNames;
    }

    public static <S extends ISample> SortedMap<Integer, String> getIndexsFirstOccurrence(List<S> samples) {
        TreeMap<Integer, String> names = new TreeMap<Integer, String>();
        int i = 0;
        while (i < samples.size()) {
            String groupName = ((ISample)samples.get(i)).getGroupName();
            if (!names.containsValue(groupName)) {
                names.putIfAbsent(i, groupName);
            }
            ++i;
        }
        return names;
    }

    public static List<IPeak> getPeaks(IPeaks<?> peaks, int leftRetentionTimeBound, int rightRetentionTimeBound) {
        ArrayList<IPeak> peakInInterval = new ArrayList<IPeak>();
        for (IPeak peak : peaks.getPeaks()) {
            int retentionTime = peak.getPeakModel().getRetentionTimeAtPeakMaximum();
            if (retentionTime < leftRetentionTimeBound || retentionTime > rightRetentionTimeBound) continue;
            peakInInterval.add(peak);
        }
        return peakInInterval;
    }

    public static List<TreeSet<String>> getPeaksNames(List<Sample> samples, boolean onlySelected) {
        ArrayList<TreeSet<String>> map = new ArrayList<TreeSet<String>>();
        if (!samples.isEmpty()) {
            int lenght = samples.get(0).getSampleData().size();
            int i = 0;
            while (i < lenght) {
                map.add(new TreeSet());
                ++i;
            }
            int j = 0;
            while (j < lenght) {
                for (Sample sample : samples) {
                    ArrayList target;
                    Optional<IPeak> peak;
                    if (!sample.isSelected() && onlySelected || !(peak = ((PeakSampleData)((Object)sample.getSampleData().get(j))).getPeak()).isPresent() || (target = new ArrayList(peak.get().getTargets())).size() <= 0) continue;
                    ((TreeSet)map.get(j)).add(((IIdentificationTarget)target.get(0)).getLibraryInformation().getName());
                }
                ++j;
            }
        }
        return map;
    }

    public static <S extends ISample> Map<String, Set<S>> getSamplesByGroupName(List<S> samples, boolean containsNullGroupName, boolean onlySelected) {
        HashMap<String, Set<S>> samplesByGroupName = new HashMap<String, Set<S>>();
        Set<String> groupNames = PcaUtils.getGroupNames(samples, onlySelected);
        for (String groupName : groupNames) {
            Set samplesIdenticalGroupName;
            if (groupName == null && !containsNullGroupName || (samplesIdenticalGroupName = samples.stream().filter(s -> Comparator.nullsFirst(String::compareTo).compare(groupName, s.getGroupName()) == 0 && s.isSelected()).collect(Collectors.toSet())).isEmpty()) continue;
            samplesByGroupName.put(groupName, samplesIdenticalGroupName);
        }
        return samplesByGroupName;
    }

    public static void sortPcaResultsByGroup(List<IResultPCA> pcaResults) {
        Comparator comparator = (arg0, arg1) -> {
            String name0 = arg0.getGroupName();
            String name1 = arg1.getGroupName();
            if (name0 == null && name1 == null) {
                return 0;
            }
            if (name0 != null && name1 == null) {
                return 1;
            }
            if (name0 == null && name1 != null) {
                return -1;
            }
            return name0.compareTo(name1);
        };
        Collections.sort(pcaResults, comparator);
    }

    public static void sortPcaResultsByName(List<IResultPCA> samples) {
        Comparator comparator = (arg0, arg1) -> arg0.getName().compareTo(arg1.getName());
        Collections.sort(samples, comparator);
    }

    public static void sortPcaResultsListByErrorMemberShip(List<IResultPCA> pcaResults, boolean inverse) {
        int i = 1;
        if (inverse) {
            i = -1;
        }
        int inv = i;
        Comparator comparator = (arg0, arg1) -> inv * Double.compare(arg0.getErrorMemberShip(), arg1.getErrorMemberShip());
        Collections.sort(pcaResults, comparator);
    }

    public static <S extends ISample> void sortSampleListByGroup(List<S> samples) {
        Comparator comparator = (arg0, arg1) -> {
            String name0 = arg0.getGroupName();
            String name1 = arg1.getGroupName();
            if (name0 == null && name1 == null) {
                return 0;
            }
            if (name0 != null && name1 == null) {
                return 1;
            }
            if (name0 == null && name1 != null) {
                return -1;
            }
            return name0.compareTo(name1);
        };
        Collections.sort(samples, comparator);
    }

    public static <S extends ISample> void sortSampleListByName(List<S> samples) {
        Comparator comparator = (arg0, arg1) -> arg0.getName().compareTo(arg1.getName());
        Collections.sort(samples, comparator);
    }
}

