/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.AbstractScaling;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class ScalingVast
extends AbstractScaling {
    public ScalingVast(int centeringType) {
        super(centeringType);
    }

    @Override
    public String getDescription() {
        return "Vast Scaling";
    }

    @Override
    public String getName() {
        return "Vast Scaling";
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples) {
        boolean onlySelected = this.isOnlySelected();
        int centeringType = this.getCenteringType();
        List variables = samples.getVariables();
        List samplesList = samples.getSampleList();
        int i = 0;
        while (i < variables.size()) {
            if (!this.skipVariable(samples, i)) {
                double mean = this.getCenteringValue(samplesList, i, centeringType);
                double variace = this.getVariance(samplesList, i, centeringType);
                for (ISample sample : samplesList) {
                    ISampleData sampleData = (ISampleData)sample.getSampleData().get(i);
                    if (!sample.isSelected() && onlySelected) continue;
                    double data = this.getData(sampleData);
                    double scaleData = (data - mean) / variace * mean;
                    sampleData.setModifiedData(scaleData);
                }
            }
            ++i;
        }
    }
}

