/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IPreprocessingSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.algorithms.CalculatorNIPALS;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.algorithms.CalculatorOPLS;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.algorithms.CalculatorSVD;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.exception.MathIllegalArgumentException;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.AbstractMultivariateCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Algorithm;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IMultivariateCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISamplesPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ResultsPCA;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProcessorPCA {
    public <V extends IVariable, S extends ISample> ResultsPCA process(ISamplesPCA<V, S> samples, IProgressMonitor monitor) throws MathIllegalArgumentException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Run PCA", (int)140);
        IAnalysisSettings analysisSettings = samples.getAnalysisSettings();
        ResultsPCA pcaResults = new ResultsPCA(analysisSettings);
        try {
            IPreprocessingSettings preprocessingSettings = analysisSettings.getPreprocessingSettings();
            preprocessingSettings.process(samples, monitor);
            subMonitor.worked(20);
            IFilterSettings filterSettings = analysisSettings.getFilterSettings();
            filterSettings.process(samples, monitor);
            subMonitor.worked(20);
            int numberOfPrincipalComponents = analysisSettings.getNumberOfPrincipalComponents();
            Algorithm algorithm = analysisSettings.getAlgorithm();
            boolean[] isSelectedVariables = this.selectedVariables(samples, analysisSettings);
            Map<ISample, double[]> extractData = this.extractData(samples, algorithm, analysisSettings, isSelectedVariables);
            this.setRetentionTime(pcaResults, samples, isSelectedVariables);
            int numVars = this.getNumSampleVars(extractData);
            subMonitor.worked(20);
            IMultivariateCalculator principalComponentAnalysis = this.setupPCA(extractData, numVars, numberOfPrincipalComponents, algorithm);
            subMonitor.worked(20);
            principalComponentAnalysis.compute();
            subMonitor.worked(20);
            if (!principalComponentAnalysis.getComputeStatus()) {
                return null;
            }
            subMonitor.worked(20);
            List<double[]> loadingVectors = this.getLoadingVectors(principalComponentAnalysis, numberOfPrincipalComponents);
            double[] explainedVariances = this.getExplainedVariances(principalComponentAnalysis, numberOfPrincipalComponents);
            double[] cumulativeExplainedVariances = this.getCumulativeExplainedVariances(explainedVariances);
            pcaResults.setLoadingVectors(loadingVectors);
            pcaResults.setExplainedVariances(explainedVariances);
            pcaResults.setCumulativeExplainedVariances(cumulativeExplainedVariances);
            this.setEigenSpaceAndErrorValues(principalComponentAnalysis, extractData, pcaResults);
            subMonitor.worked(20);
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
        return pcaResults;
    }

    private <V extends IVariable, S extends ISample> Map<ISample, double[]> extractData(ISamples<V, S> samples, Algorithm algorithm, IAnalysisSettings settings, boolean[] isSelectedVariable) {
        HashMap<ISample, double[]> selectedSamples = new HashMap<ISample, double[]>();
        List retentionTimes = samples.getVariables();
        int i = 0;
        while (i < isSelectedVariable.length) {
            isSelectedVariable[i] = isSelectedVariable[i] & ((IVariable)retentionTimes.get(i)).isSelected();
            if (settings.isRemoveUselessVariables()) {
                int numEmptyValues = 0;
                for (ISample sample : samples.getSampleList()) {
                    if (((ISampleData)sample.getSampleData().get(i)).isEmpty()) continue;
                    ++numEmptyValues;
                }
                if (numEmptyValues <= 1) {
                    isSelectedVariable[i] = false;
                }
            }
            ++i;
        }
        int numSelected = 0;
        boolean[] blArray = isSelectedVariable;
        int n = isSelectedVariable.length;
        int sample = 0;
        while (sample < n) {
            boolean b = blArray[sample];
            if (b) {
                ++numSelected;
            }
            ++sample;
        }
        Set groups = samples.getSampleList().stream().map(s -> s.getGroupName()).distinct().collect(Collectors.toList()).stream().limit(2L).collect(Collectors.toSet());
        for (ISample sample2 : samples.getSampleList()) {
            double[] selectedSampleData = null;
            if (!sample2.isSelected()) continue;
            List data = sample2.getSampleData();
            selectedSampleData = new double[numSelected];
            int j = 0;
            int i2 = 0;
            while (i2 < data.size()) {
                if (isSelectedVariable[i2]) {
                    selectedSampleData[j] = ((ISampleData)data.get(i2)).getModifiedData();
                    ++j;
                }
                ++i2;
            }
            selectedSamples.put(sample2, selectedSampleData);
        }
        if (algorithm.equals((Object)Algorithm.OPLS)) {
            Map<ISample, double[]> groupSelected = selectedSamples.entrySet().stream().filter(e -> groups.contains(((ISample)e.getKey()).getGroupName())).collect(Collectors.toMap(e -> (ISample)e.getKey(), e -> (double[])e.getValue()));
            return groupSelected;
        }
        return selectedSamples;
    }

    private <V extends IVariable, S extends ISample> boolean[] selectedVariables(ISamples<V, S> samples, IAnalysisSettings settings) {
        List retentionTimes = samples.getVariables();
        boolean[] isSelectedVariable = new boolean[retentionTimes.size()];
        Arrays.fill(isSelectedVariable, true);
        int i = 0;
        while (i < isSelectedVariable.length) {
            isSelectedVariable[i] = isSelectedVariable[i] & ((IVariable)retentionTimes.get(i)).isSelected();
            if (settings.isRemoveUselessVariables()) {
                int numEmptyValues = 0;
                for (ISample sample : samples.getSampleList()) {
                    if (!sample.isSelected() || ((ISampleData)sample.getSampleData().get(i)).isEmpty()) continue;
                    ++numEmptyValues;
                }
                if (numEmptyValues <= 1) {
                    isSelectedVariable[i] = false;
                }
            }
            ++i;
        }
        return isSelectedVariable;
    }

    private List<double[]> getLoadingVectors(IMultivariateCalculator principalComponentAnalysis, int numberOfPrincipalComponents) {
        ArrayList<double[]> loadingVectors = new ArrayList<double[]>();
        int principalComponent = 0;
        while (principalComponent < numberOfPrincipalComponents) {
            double[] loadingVector = principalComponentAnalysis.getLoadingVector(principalComponent);
            loadingVectors.add(loadingVector);
            ++principalComponent;
        }
        return loadingVectors;
    }

    private double[] getExplainedVariances(IMultivariateCalculator principalComponentAnalysis, int numberOfPrincipalComponents) {
        double summedVariance = principalComponentAnalysis.getSummedVariance();
        double[] explainedVariances = new double[numberOfPrincipalComponents];
        int i = 0;
        while (i < numberOfPrincipalComponents) {
            explainedVariances[i] = 100.0 / summedVariance * principalComponentAnalysis.getExplainedVariance(i);
            ++i;
        }
        return explainedVariances;
    }

    private double[] getCumulativeExplainedVariances(double[] explainedVariances) {
        double[] cumulativeExplainedVariances = new double[explainedVariances.length];
        double cumVarTemp = 0.0;
        int i = 0;
        while (i < explainedVariances.length) {
            cumulativeExplainedVariances[i] = cumVarTemp + explainedVariances[i];
            cumVarTemp = cumulativeExplainedVariances[i];
            ++i;
        }
        return cumulativeExplainedVariances;
    }

    private int getNumSampleVars(Map<ISample, double[]> extractData) {
        Iterator<Map.Entry<ISample, double[]>> it = extractData.entrySet().iterator();
        if (it.hasNext()) {
            return it.next().getValue().length;
        }
        return -1;
    }

    private IMultivariateCalculator setupPCA(Map<ISample, double[]> pcaPeakMap, int sampleSize, int numberOfPrincipalComponents, Algorithm algorithm) throws MathIllegalArgumentException {
        int numSamples = pcaPeakMap.size();
        AbstractMultivariateCalculator principalComponentAnalysis = null;
        if (algorithm.equals((Object)Algorithm.NIPALS)) {
            principalComponentAnalysis = new CalculatorNIPALS(numSamples, sampleSize, numberOfPrincipalComponents);
        } else if (algorithm.equals((Object)Algorithm.SVD)) {
            principalComponentAnalysis = new CalculatorSVD(numSamples, sampleSize, numberOfPrincipalComponents);
        } else if (algorithm.equals((Object)Algorithm.OPLS)) {
            principalComponentAnalysis = new CalculatorOPLS(numSamples, sampleSize, numberOfPrincipalComponents);
        }
        for (Map.Entry<ISample, double[]> entry : pcaPeakMap.entrySet()) {
            principalComponentAnalysis.addObservation(entry.getValue(), entry.getKey(), entry.getKey().getGroupName());
        }
        return principalComponentAnalysis;
    }

    private void setEigenSpaceAndErrorValues(IMultivariateCalculator principalComponentAnalysis, Map<ISample, double[]> pcaPeakMap, IResultsPCA<IResultPCA, IVariable> pcaResults) {
        ArrayList<ResultPCA> resultsList = new ArrayList<ResultPCA>();
        for (Map.Entry<ISample, double[]> entry : pcaPeakMap.entrySet()) {
            double[] sampleData = entry.getValue();
            ISample sample = entry.getKey();
            ResultPCA pcaResult = new ResultPCA(sample);
            pcaResult.setName(sample.getName());
            pcaResult.setGroupName(sample.getGroupName());
            pcaResult.setScoreVector(principalComponentAnalysis.getScoreVector(sample));
            pcaResult.setErrorMemberShip(principalComponentAnalysis.getErrorMetric(sampleData));
            pcaResult.setSampleData(sampleData);
            resultsList.add(pcaResult);
        }
        pcaResults.getPcaResultList().clear();
        pcaResults.getPcaResultList().addAll(resultsList);
    }

    private void setRetentionTime(IResultsPCA<IResultPCA, IVariable> pcaResults, ISamples<? extends IVariable, ? extends ISample> samples, boolean[] isSelectedVariables) {
        pcaResults.getExtractedVariables().clear();
        int i = 0;
        while (i < samples.getVariables().size()) {
            if (isSelectedVariables[i]) {
                IVariable variable = (IVariable)samples.getVariables().get(i);
                pcaResults.getExtractedVariables().add(variable);
            }
            ++i;
        }
    }
}

