/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.OneWayAnova;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.PcaUtils;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AbstractFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class AnovaFilter
extends AbstractFilter
implements IFilter {
    private double alpha = 0.05;
    private final String name = "Anova filter";
    private String selectionResult = "";

    public AnovaFilter() {
        super(IFilter.DataTypeProcessing.RAW_DATA);
    }

    @Override
    public <V extends IVariable, S extends ISample> List<Boolean> filter(ISamples<V, S> samples) {
        List<S> samplesList = this.selectSamples(samples);
        List variables = samples.getVariables();
        ArrayList<Boolean> selection = new ArrayList<Boolean>(variables.size());
        int i = 0;
        while (i < variables.size()) {
            selection.add(false);
            ++i;
        }
        Map<String, Set<S>> samplesByGroupNameMap = PcaUtils.getSamplesByGroupName(samplesList, false, this.isOnlySelected());
        Collection<Set<S>> samplesByGroupName = samplesByGroupNameMap.values();
        try {
            int i2 = 0;
            while (i2 < selection.size()) {
                OneWayAnova oneWayAnova = new OneWayAnova();
                ArrayList<SummaryStatistics> categoryData = new ArrayList<SummaryStatistics>();
                for (Set<S> group : samplesByGroupName) {
                    SummaryStatistics summaryStatistics = new SummaryStatistics();
                    for (ISample sample : group) {
                        double d = this.getData((ISampleData)sample.getSampleData().get(i2));
                        summaryStatistics.addValue(d);
                    }
                    categoryData.add(summaryStatistics);
                }
                double pValue = oneWayAnova.anovaPValue(categoryData, true);
                selection.set(i2, pValue < this.alpha);
                ++i2;
            }
            this.selectionResult = IFilter.getNumberSelectedRow(selection);
        }
        catch (Exception e) {
            this.selectionResult = IFilter.getErrorMessage(e.getMessage());
        }
        return selection;
    }

    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public String getDescription() {
        return "P-Value is less then " + this.alpha * 100.0 + "%";
    }

    @Override
    public String getName() {
        return "Anova filter";
    }

    @Override
    public String getSelectionResult() {
        return this.selectionResult;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

