/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.AbstractDataModificator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ICentering;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;

public abstract class AbstractCentering
extends AbstractDataModificator
implements ICentering {
    protected <S extends ISample> double getCenteringValue(List<S> list, int position, int type) {
        boolean onlySelected = this.isOnlySelected();
        DoubleStream selectedData = list.stream().filter(s -> s.isSelected() || !onlySelected).map(s -> (ISampleData)s.getSampleData().get(position)).mapToDouble(d -> this.getData((ISampleData)d));
        switch (type) {
            case 1: {
                return selectedData.summaryStatistics().getAverage();
            }
            case 2: {
                List data = selectedData.sorted().boxed().collect(Collectors.toList());
                int lenght = data.size();
                if (lenght == 0) {
                    return 0.0;
                }
                double median = lenght % 2 == 0 ? ((Double)data.get(lenght / 2 - 1) + (Double)data.get(lenght / 2)) / 2.0 : (Double)data.get(lenght / 2);
                return median;
            }
        }
        throw new RuntimeException("undefine centering");
    }

    protected <S extends ISample> double getStandartDeviation(List<S> samples, int position, int type) {
        return Math.sqrt(Math.abs(this.getVariance(samples, position, type)));
    }

    protected <S extends ISample> double getVariance(List<S> samples, int position, int type) {
        boolean onlySelected = this.isOnlySelected();
        List sampleData = samples.stream().filter(s -> s.isSelected() || !onlySelected).map(s -> (ISampleData)s.getSampleData().get(position)).collect(Collectors.toList());
        int count = sampleData.size();
        if (count > 1) {
            double mean = this.getCenteringValue(samples, position, type);
            double sum = sampleData.stream().mapToDouble(d2 -> {
                double data = this.getData((ISampleData)d2);
                return (data - mean) * (data - mean);
            }).sum();
            return sum / (double)(count - 1);
        }
        return 0.0;
    }
}

