/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class SampleQuantReport
implements ISampleQuantReport {
    private String name;
    private String dataName;
    private String date;
    private String operator;
    private String miscInfo;
    private String pathChromatogramEdited = "";
    private String pathChromatogramOriginal = "";
    private List<ISampleQuantSubstance> sampleQuantSubstances = new ArrayList<ISampleQuantSubstance>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDataName() {
        return this.dataName;
    }

    @Override
    public void setDataName(String dataName) {
        this.dataName = dataName;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public String getMiscInfo() {
        return this.miscInfo;
    }

    @Override
    public void setMiscInfo(String miscInfo) {
        this.miscInfo = miscInfo;
    }

    @Override
    public String getPathChromatogramOriginal() {
        return this.pathChromatogramOriginal;
    }

    @Override
    public void setPathChromatogramOriginal(String pathChromatogramOriginal) {
        this.pathChromatogramOriginal = pathChromatogramOriginal;
    }

    @Override
    public String getPathChromatogramEdited() {
        return this.pathChromatogramEdited;
    }

    @Override
    public void setPathChromatogramEdited(String pathChromatogramEdited) {
        this.pathChromatogramEdited = pathChromatogramEdited;
    }

    @Override
    public void setMinMatchQuality(double minMatchQuality) {
        for (ISampleQuantSubstance sampleQuantSubstance : this.sampleQuantSubstances) {
            sampleQuantSubstance.setMinMatchQuality(minMatchQuality);
        }
    }

    @Override
    public List<ISampleQuantSubstance> getSampleQuantSubstances() {
        return this.sampleQuantSubstances;
    }

    @Override
    public List<ISampleQuantSubstance> getSampleQuantSubstances(String searchTerms) {
        if (searchTerms == null || searchTerms == "") {
            return this.sampleQuantSubstances;
        }
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        boolean isCaseSensitive = preferences.getBoolean("samplequantSearchCaseSensitive", false);
        if (!isCaseSensitive) {
            searchTerms = searchTerms.toLowerCase();
        }
        ArrayList<ISampleQuantSubstance> sampleQuantSubstancesSearch = new ArrayList<ISampleQuantSubstance>();
        String[] searchItems = searchTerms.split(" ");
        for (ISampleQuantSubstance sampleQuantSubstance : this.sampleQuantSubstances) {
            String name = isCaseSensitive ? sampleQuantSubstance.getName() : sampleQuantSubstance.getName().toLowerCase();
            String casNumber = sampleQuantSubstance.getCasNumber();
            String[] stringArray = searchItems;
            int n = searchItems.length;
            int n2 = 0;
            while (n2 < n) {
                String searchItem = stringArray[n2];
                if (name.contains(searchItem) || casNumber.contains(searchItem)) {
                    sampleQuantSubstancesSearch.add(sampleQuantSubstance);
                }
                ++n2;
            }
        }
        return sampleQuantSubstancesSearch;
    }
}

