/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.quantitation;

import java.io.File;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.quantitation.IQuantDBExportConverter;
import org.eclipse.chemclipse.converter.quantitation.IQuantDBImportConverter;
import org.eclipse.chemclipse.converter.quantitation.QuantDBConverterSupport;
import org.eclipse.chemclipse.converter.quantitation.QuantDBSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class QuantDBConverter {
    public static final String DEFAULT_QUANT_DB_CONVERTER_ID = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.quantitationDatabaseSupplier";
    public static final String DEFAULT_QUANT_DB_FILE_NAME = "QuantitationDatabase.ocq";
    public static final String[] DEFAULT_QUANT_DB_FILE_EXTENSIONS = new String[]{"*.ocq"};
    public static final String[] DEFAULT_QUANT_DB_FILE_NAMES = new String[]{"Quantitation Database (*.ocq)"};
    private static final Logger logger = Logger.getLogger(QuantDBConverter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.converter.quantitationDatabaseSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String FILE_NAME = "fileName";
    private static final String IMPORT_CONVERTER = "importConverter";
    private static final String EXPORT_CONVERTER = "exportConverter";
    private static final String IS_EXPORTABLE = "isExportable";
    private static final String IS_IMPORTABLE = "isImportable";
    private static final String IMPORT_MAGIC_NUMBER_MATCHER = "importMagicNumberMatcher";

    private QuantDBConverter() {
    }

    public static IProcessingInfo<IQuantitationDatabase> convert(File file, IProgressMonitor monitor) {
        QuantDBConverterSupport converterSupport = QuantDBConverter.getQuantDBConverterSupport();
        for (ISupplier supplier : converterSupport.getSupplier()) {
            IProcessingInfo processinInfo = QuantDBConverter.convert(file, supplier.getId(), monitor);
            IQuantitationDatabase quantitationDatabase = (IQuantitationDatabase)processinInfo.getProcessingResult();
            if (quantitationDatabase == null) continue;
            return processinInfo;
        }
        return QuantDBConverter.getNoImportConverterAvailableProcessingInfo(file);
    }

    public static <R> IProcessingInfo<R> convert(File file, String converterId, IProgressMonitor monitor) {
        IQuantDBImportConverter<R> importConverter = QuantDBConverter.getImportConverter(converterId);
        IProcessingInfo<R> processingInfo = importConverter != null ? importConverter.convert(file, monitor) : QuantDBConverter.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static <R> IProcessingInfo<R> convert(File file, IQuantitationDatabase quantitationDatabase, String converterId, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = null;
        QuantDBConverterSupport converterSupport = QuantDBConverter.getQuantDBConverterSupport();
        for (ISupplier supplier : converterSupport.getSupplier()) {
            if (!supplier.isExportable() || !supplier.getId().equals(converterId)) continue;
            IQuantDBExportConverter exportConverter = QuantDBConverter.getExportConverter(converterId);
            processingInfo = exportConverter.convert(file, quantitationDatabase, monitor);
            break;
        }
        if (processingInfo == null) {
            processingInfo = QuantDBConverter.getNoExportConverterAvailableProcessingInfo(file);
        }
        return processingInfo;
    }

    private static <R> IQuantDBImportConverter<R> getImportConverter(String converterId) {
        IConfigurationElement element = QuantDBConverter.getConfigurationElement(converterId);
        IQuantDBImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IQuantDBImportConverter)element.createExecutableExtension(IMPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IQuantDBExportConverter getExportConverter(String converterId) {
        IConfigurationElement element = QuantDBConverter.getConfigurationElement(converterId);
        IQuantDBExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IQuantDBExportConverter)element.createExecutableExtension(EXPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static QuantDBConverterSupport getQuantDBConverterSupport() {
        IConfigurationElement[] extensions;
        QuantDBConverterSupport converterSupport = new QuantDBConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            QuantDBSupplier supplier = new QuantDBSupplier();
            supplier.setFileExtension(element.getAttribute(FILE_EXTENSION));
            supplier.setFileName(element.getAttribute(FILE_NAME));
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            supplier.setExportable(Boolean.valueOf(element.getAttribute(IS_EXPORTABLE)));
            supplier.setImportable(Boolean.valueOf(element.getAttribute(IS_IMPORTABLE)));
            supplier.setMagicNumberMatcher(QuantDBConverter.getMagicNumberMatcher(element));
            converterSupport.add(supplier);
            ++n2;
        }
        return converterSupport;
    }

    private static <R> IProcessingInfo<R> getNoImportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage("QuantDB Import Converter", "There is no suitable converter available to load the database from the file: " + file.getAbsolutePath());
        return processingInfo;
    }

    private static <R> IProcessingInfo<R> getNoExportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage("QuantDB Export Converter", "There is no suitable converter available to write the database to the file: " + file.getAbsolutePath());
        return processingInfo;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension(IMPORT_MAGIC_NUMBER_MATCHER);
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }
}

