/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.sequence;

import java.io.File;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.model.reports.ISequence;
import org.eclipse.chemclipse.converter.sequence.ISequenceImportConverter;
import org.eclipse.chemclipse.converter.sequence.SequenceConverterSupport;
import org.eclipse.chemclipse.converter.sequence.SequenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class SequenceConverter {
    private static final Logger logger = Logger.getLogger(SequenceConverter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.converter.sequenceImportSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String FILE_NAME = "fileName";
    private static final String IMPORT_CONVERTER = "importConverter";
    private static final String IMPORT_MAGIC_NUMBER_MATCHER = "importMagicNumberMatcher";

    private SequenceConverter() {
    }

    public static IProcessingInfo<ISequence<?>> convert(File file, IProgressMonitor monitor) {
        SequenceConverterSupport sequenceConverterSupport = SequenceConverter.getSequenceConverterSupport();
        for (ISupplier supplier : sequenceConverterSupport.getSupplier()) {
            IProcessingInfo processinInfo = SequenceConverter.convert(file, supplier.getId(), monitor);
            ISequence sequence = (ISequence)processinInfo.getProcessingResult();
            if (sequence == null) continue;
            return processinInfo;
        }
        return SequenceConverter.getNoImportConverterAvailableProcessingInfo(file);
    }

    public static IProcessingInfo convert(File file, String converterId, IProgressMonitor monitor) {
        ISequenceImportConverter importConverter = SequenceConverter.getSequenceImportConverter(converterId);
        IProcessingInfo processingInfo = importConverter != null ? importConverter.convert(file, monitor) : SequenceConverter.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private static ISequenceImportConverter getSequenceImportConverter(String converterId) {
        IConfigurationElement element = SequenceConverter.getConfigurationElement(converterId);
        ISequenceImportConverter instance = null;
        if (element != null) {
            try {
                instance = (ISequenceImportConverter)element.createExecutableExtension(IMPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static SequenceConverterSupport getSequenceConverterSupport() {
        IConfigurationElement[] extensions;
        SequenceConverterSupport sequenceConverterSupport = new SequenceConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            SequenceSupplier supplier = new SequenceSupplier();
            supplier.setFileExtension(element.getAttribute(FILE_EXTENSION));
            supplier.setFileName(element.getAttribute(FILE_NAME));
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            supplier.setMagicNumberMatcher(SequenceConverter.getMagicNumberMatcher(element));
            sequenceConverterSupport.add(supplier);
            ++n2;
        }
        return sequenceConverterSupport;
    }

    private static IProcessingInfo getNoImportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage("Sequence Import Converter", "There is no suitable converter available to load the sequence from the file: " + file.getAbsolutePath());
        return processingInfo;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension(IMPORT_MAGIC_NUMBER_MATCHER);
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }
}

