/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.core;

import java.io.File;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.core.ISupplierSetter;
import org.eclipse.chemclipse.processing.converter.ISupplier;

public abstract class AbstractSupplier
implements ISupplierSetter {
    private String id = "";
    private String description = "";
    private String filterName = "";
    private String fileExtension = "";
    private String fileName = "";
    private String directoryExtension = "";
    private boolean exportable = false;
    private boolean importable = false;
    private IMagicNumberMatcher magicNumberMatcher = null;

    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (id != null) {
            this.id = id;
        }
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public void setFilterName(String filterName) {
        if (filterName != null) {
            this.filterName = filterName;
        }
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension == null ? "" : fileExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        if (fileName != null) {
            this.fileName = fileName;
        }
    }

    public String getDirectoryExtension() {
        return this.directoryExtension;
    }

    @Override
    public void setDirectoryExtension(String directoryExtension) {
        String extension = directoryExtension;
        if (directoryExtension != null) {
            if (!"".equals(directoryExtension)) {
                extension = directoryExtension.startsWith(".") ? directoryExtension : "." + directoryExtension;
            }
            this.directoryExtension = extension;
        }
    }

    public boolean isExportable() {
        return this.exportable;
    }

    @Override
    public void setExportable(boolean isExportable) {
        this.exportable = isExportable;
    }

    public boolean isImportable() {
        return this.importable;
    }

    @Override
    public void setImportable(boolean isImportable) {
        this.importable = isImportable;
    }

    public boolean isMatchMagicNumber(File file) {
        if (this.magicNumberMatcher != null) {
            return this.magicNumberMatcher.checkFileFormat(file);
        }
        return false;
    }

    @Override
    public void setMagicNumberMatcher(IMagicNumberMatcher magicNumberMatcher) {
        this.magicNumberMatcher = magicNumberMatcher;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ISupplier other = (ISupplier)otherObject;
        return this.id.equals(other.getId()) && this.description.equals(other.getDescription()) && this.filterName.equals(other.getFilterName()) && this.fileExtension.equals(other.getFileExtension()) && this.fileName.equals(other.getFileName()) && this.directoryExtension.equals(other.getDirectoryExtension()) && this.exportable == other.isExportable() && this.importable == other.isImportable();
    }

    public int hashCode() {
        return this.id.hashCode() + this.description.hashCode() + this.filterName.hashCode() + this.fileExtension.hashCode() + this.fileName.hashCode() + this.directoryExtension.hashCode() + Boolean.valueOf(this.exportable).hashCode() + Boolean.valueOf(this.importable).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("id=" + this.id);
        builder.append(",description=" + this.description);
        builder.append(",filterName=" + this.filterName);
        builder.append(",fileExtension=" + this.fileExtension);
        builder.append(",fileName=" + this.fileName);
        builder.append(",directoryExtension=" + this.directoryExtension);
        builder.append(",isExportable=" + this.exportable);
        builder.append(",isImportable=" + this.importable);
        builder.append("]");
        return builder.toString();
    }
}

