/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.baseline;

import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.chemclipse.model.baseline.BaselineSegment;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.baseline.IBaselineSegment;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.BaselineIsNotDefinedException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;

public class BaselineModel
implements IBaselineModel {
    private transient IChromatogram chromatogram;
    private NavigableMap<Integer, IBaselineSegment> baselineSegments;
    private float defaultBackgroundAbundance;
    private boolean interpolate;

    public BaselineModel(IChromatogram chromatogram) {
        this.chromatogram = chromatogram;
        this.baselineSegments = new TreeMap<Integer, IBaselineSegment>();
        this.defaultBackgroundAbundance = 0.0f;
        this.interpolate = false;
    }

    public BaselineModel(IChromatogram chromatogram, float defaultBackgroundAbundance) {
        this.chromatogram = chromatogram;
        this.baselineSegments = new TreeMap<Integer, IBaselineSegment>();
        this.defaultBackgroundAbundance = defaultBackgroundAbundance;
        this.interpolate = Double.isNaN(defaultBackgroundAbundance);
    }

    @Override
    public void addBaseline(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance, boolean validate) {
        if (startRetentionTime >= stopRetentionTime) {
            return;
        }
        if (validate) {
            this.addBaselineChecked(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance);
        } else {
            this.addBaselineUnchecked(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance);
        }
    }

    @Override
    public void addBaseline(ITotalScanSignals totalIonSignals) {
        if (totalIonSignals.size() == 0) {
            return;
        }
        ITotalScanSignal firstTotalSignal = totalIonSignals.getFirstTotalScanSignal();
        ITotalScanSignal lastTotalSignal = totalIonSignals.getLastTotalScanSignal();
        this.removeBaselineSegments(firstTotalSignal.getRetentionTime(), lastTotalSignal.getRetentionTime(), firstTotalSignal.getTotalSignal(), lastTotalSignal.getTotalSignal());
        int scan = totalIonSignals.getStartScan();
        while (scan < totalIonSignals.getStopScan()) {
            ITotalScanSignal actualTotalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            ITotalScanSignal nextTotalIonSignal = totalIonSignals.getNextTotalScanSignal(scan);
            int startRetentionTime = actualTotalIonSignal.getRetentionTime();
            float startBackgroundAbundance = actualTotalIonSignal.getTotalSignal();
            int stopRetentionTime = nextTotalIonSignal.getRetentionTime();
            float stopBackgroundAbundance = nextTotalIonSignal.getTotalSignal();
            this.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++scan;
        }
    }

    private void removeBaselineSegments(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance) {
        this.removeMiddleSegments(startRetentionTime, stopRetentionTime);
        this.cutSegmentInTwoParts(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance);
        this.cutSegmentBeginningPart(startRetentionTime, stopRetentionTime, stopBackgroundAbundance);
        this.cutSegmentEndingPart(startRetentionTime, stopRetentionTime, startBackgroundAbundance);
    }

    private void removeMiddleSegments(int startRetentionTime, int stopRetentionTime) {
        SortedMap<Integer, IBaselineSegment> sortedMap = this.baselineSegments.subMap(startRetentionTime, stopRetentionTime);
        HashSet<Integer> keyToRemove = new HashSet<Integer>();
        for (Map.Entry<Integer, IBaselineSegment> entry : sortedMap.entrySet()) {
            int stopRetentionTimeRemoveSegment = entry.getValue().getStopRetentionTime();
            if (stopRetentionTimeRemoveSegment > stopRetentionTime) continue;
            keyToRemove.add(entry.getKey());
        }
        keyToRemove.forEach(k -> {
            Object v = this.baselineSegments.remove(k);
        });
    }

    private void cutSegmentBeginningPart(int startRetentionTime, int stopRetentionTime, float stopBackgroundAbundance) {
        Map.Entry<Integer, IBaselineSegment> cuttingSegmentEntry = this.baselineSegments.floorEntry(startRetentionTime);
        cuttingSegmentEntry = this.baselineSegments.floorEntry(stopRetentionTime);
        if (cuttingSegmentEntry != null) {
            IBaselineSegment cuttingSegment = cuttingSegmentEntry.getValue();
            int x0 = cuttingSegment.getStartRetentionTime();
            int x1 = cuttingSegment.getStopRetentionTime();
            if (startRetentionTime <= x0 && x0 <= stopRetentionTime && stopRetentionTime < x1) {
                this.baselineSegments.remove(cuttingSegmentEntry.getKey());
                int partSegmentStartRetentionTime = stopRetentionTime + 1;
                int partSegmentStopRetentionTime = x1;
                float partSegmentStartAbundance = cuttingSegment.getBackgroundAbundance(partSegmentStartRetentionTime);
                float partSegmentStopAbundance = cuttingSegment.getStopBackgroundAbundance();
                if (partSegmentStartRetentionTime != partSegmentStopRetentionTime) {
                    this.addBaselineUnchecked(partSegmentStartRetentionTime, partSegmentStopRetentionTime, partSegmentStartAbundance, partSegmentStopAbundance);
                } else if (!Float.isNaN(stopBackgroundAbundance)) {
                    this.addBaselineUnchecked(--partSegmentStartRetentionTime, partSegmentStopRetentionTime, stopBackgroundAbundance, partSegmentStopAbundance);
                }
            }
        }
    }

    private void cutSegmentEndingPart(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance) {
        Map.Entry<Integer, IBaselineSegment> cuttingSegmentEntry = this.baselineSegments.floorEntry(startRetentionTime);
        cuttingSegmentEntry = this.baselineSegments.floorEntry(startRetentionTime);
        if (cuttingSegmentEntry != null) {
            IBaselineSegment cuttingSegment = cuttingSegmentEntry.getValue();
            int x0 = cuttingSegment.getStartRetentionTime();
            int x1 = cuttingSegment.getStopRetentionTime();
            if (x0 < startRetentionTime && startRetentionTime <= x1 && x1 <= stopRetentionTime) {
                this.baselineSegments.remove(cuttingSegmentEntry.getKey());
                int partSegmentStartRetentionTime = x0;
                int partSegmentStopRetentionTime = startRetentionTime - 1;
                float partSegmentStartAbundance = cuttingSegment.getStartBackgroundAbundance();
                float partSegmentStopAbundance = cuttingSegment.getBackgroundAbundance(partSegmentStopRetentionTime);
                if (partSegmentStartRetentionTime != partSegmentStopRetentionTime) {
                    this.addBaselineUnchecked(partSegmentStartRetentionTime, partSegmentStopRetentionTime, partSegmentStartAbundance, partSegmentStopAbundance);
                } else if (!Float.isNaN(startBackgroundAbundance)) {
                    this.addBaselineUnchecked(partSegmentStartRetentionTime, ++partSegmentStopRetentionTime, partSegmentStartAbundance, startBackgroundAbundance);
                }
            }
        }
    }

    private void cutSegmentInTwoParts(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance) {
        Map.Entry<Integer, IBaselineSegment> cuttingSegmentEntry = this.baselineSegments.floorEntry(startRetentionTime);
        if (cuttingSegmentEntry != null) {
            IBaselineSegment cuttingSegment = cuttingSegmentEntry.getValue();
            int x0 = cuttingSegment.getStartRetentionTime();
            int x1 = cuttingSegment.getStopRetentionTime();
            if (x0 < startRetentionTime && stopRetentionTime < x1) {
                this.baselineSegments.remove(cuttingSegmentEntry.getKey());
                int firstPartSegmentStartRetentionTime = x0;
                int firstPartSegmentStopRetentionTime = startRetentionTime - 1;
                float firstPartSegmentStartAbundance = cuttingSegment.getStartBackgroundAbundance();
                float firstPartSegmentStopAbundance = cuttingSegment.getBackgroundAbundance(firstPartSegmentStopRetentionTime);
                if (firstPartSegmentStartRetentionTime != firstPartSegmentStopRetentionTime) {
                    this.addBaselineUnchecked(firstPartSegmentStartRetentionTime, firstPartSegmentStopRetentionTime, firstPartSegmentStartAbundance, firstPartSegmentStopAbundance);
                } else if (!Float.isNaN(startBackgroundAbundance)) {
                    this.addBaselineUnchecked(firstPartSegmentStartRetentionTime, ++firstPartSegmentStopRetentionTime, firstPartSegmentStartAbundance, startBackgroundAbundance);
                }
                int secondPartSegmentStartRetentionTime = stopRetentionTime + 1;
                int secondPartSegmentStopRetentionTime = x1;
                float secondPartSegmentStartAbundance = cuttingSegment.getBackgroundAbundance(secondPartSegmentStartRetentionTime);
                float secondPartSegmentStopAbundance = cuttingSegment.getStopBackgroundAbundance();
                if (firstPartSegmentStartRetentionTime != firstPartSegmentStopRetentionTime) {
                    this.addBaselineUnchecked(secondPartSegmentStartRetentionTime, secondPartSegmentStopRetentionTime, secondPartSegmentStartAbundance, secondPartSegmentStopAbundance);
                } else if (!Float.isNaN(stopBackgroundAbundance)) {
                    secondPartSegmentStartRetentionTime = stopRetentionTime - 1;
                    this.addBaselineUnchecked(secondPartSegmentStartRetentionTime, secondPartSegmentStopRetentionTime, stopBackgroundAbundance, secondPartSegmentStopAbundance);
                }
            }
        }
    }

    @Override
    public void removeBaseline() {
        this.clearBaseline();
    }

    @Override
    @Deprecated
    public float getBackgroundAbundance(int retentionTime) {
        float defaultBackgroundAbundance = 0.0f;
        if (retentionTime < this.chromatogram.getStartRetentionTime() || retentionTime > this.chromatogram.getStopRetentionTime()) {
            return defaultBackgroundAbundance;
        }
        return this.getBackground(retentionTime, defaultBackgroundAbundance);
    }

    @Override
    public float getBackground(int retentionTime) {
        return this.getBackground(retentionTime, this.defaultBackgroundAbundance);
    }

    private float getBackground(int retentionTime, float defaultAbudance) {
        if (this.baselineSegments.isEmpty() || retentionTime < (Integer)this.baselineSegments.firstKey() || retentionTime > this.baselineSegments.lastEntry().getValue().getStopRetentionTime()) {
            return defaultAbudance;
        }
        IBaselineSegment floorSegment = this.baselineSegments.floorEntry(retentionTime).getValue();
        int stopRetentionTime = floorSegment.getStopRetentionTime();
        if (retentionTime <= stopRetentionTime) {
            return floorSegment.getBackgroundAbundance(retentionTime);
        }
        if (this.interpolate) {
            IBaselineSegment ceilSegment = this.baselineSegments.ceilingEntry(retentionTime).getValue();
            Point p1 = new Point((double)floorSegment.getStopRetentionTime(), (double)floorSegment.getStopBackgroundAbundance());
            Point p2 = new Point((double)ceilSegment.getStartRetentionTime(), (double)ceilSegment.getStartBackgroundAbundance());
            return (float)Equations.createLinearEquation((IPoint)p1, (IPoint)p2).calculateY((double)retentionTime);
        }
        return defaultAbudance;
    }

    @Override
    public float getBackgroundNotNaN(int retentionTime) throws BaselineIsNotDefinedException {
        float background = this.getBackground(retentionTime);
        if (background != Float.NaN) {
            return background;
        }
        throw new BaselineIsNotDefinedException();
    }

    @Override
    public IBaselineModel makeDeepCopy() {
        BaselineModel baselineModelCopy = new BaselineModel(this.chromatogram, this.defaultBackgroundAbundance);
        for (IBaselineSegment segment : this.baselineSegments.values()) {
            int startRT = segment.getStartRetentionTime();
            int stopRT = segment.getStopRetentionTime();
            float startAB = segment.getStartBackgroundAbundance();
            float stopAB = segment.getStopBackgroundAbundance();
            baselineModelCopy.addBaseline(startRT, stopRT, startAB, stopAB, false);
        }
        return baselineModelCopy;
    }

    private void addBaselineUnchecked(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance) {
        BaselineSegment segment = new BaselineSegment(startRetentionTime, stopRetentionTime);
        segment.setStartBackgroundAbundance(startBackgroundAbundance);
        segment.setStopBackgroundAbundance(stopBackgroundAbundance);
        this.baselineSegments.put(segment.getStartRetentionTime(), segment);
    }

    private void addBaselineChecked(int startRetentionTime, int stopRetentionTime, float startBackgroundAbundance, float stopBackgroundAbundance) {
        this.removeBaselineSegments(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance);
        this.addBaselineUnchecked(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance);
    }

    private void clearBaseline() {
        if (this.baselineSegments != null) {
            this.baselineSegments.clear();
        }
    }

    @Override
    public void removeBaseline(int startRetentionTime, int stopRetentionTime) {
        if (startRetentionTime >= stopRetentionTime) {
            return;
        }
        this.removeBaselineSegments(startRetentionTime, stopRetentionTime, Float.NaN, Float.NaN);
    }
}

