/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.identifier;

import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.targets.AbstractTarget;

public abstract class AbstractIdentificationTarget
extends AbstractTarget
implements IIdentificationTarget {
    private static final long serialVersionUID = 6432468872857861173L;
    private ILibraryInformation libraryInformation;
    private IComparisonResult comparisonResult;
    private String identifier = "";
    private boolean manuallyVerified = false;

    public AbstractIdentificationTarget(ILibraryInformation libraryInformation, IComparisonResult comparisonResult) throws ReferenceMustNotBeNullException {
        if (libraryInformation == null) {
            throw new ReferenceMustNotBeNullException("The reference libraryInformation must be not null.");
        }
        if (comparisonResult == null) {
            throw new ReferenceMustNotBeNullException("The reference comparisonResult must be not null.");
        }
        this.libraryInformation = libraryInformation;
        this.comparisonResult = comparisonResult;
    }

    @Override
    public ILibraryInformation getLibraryInformation() {
        return this.libraryInformation;
    }

    @Override
    public IComparisonResult getComparisonResult() {
        return this.comparisonResult;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        if (identifier != null) {
            this.identifier = identifier;
        }
    }

    @Override
    public boolean isManuallyVerified() {
        return this.manuallyVerified;
    }

    @Override
    public void setManuallyVerified(boolean manuallyVerified) {
        this.manuallyVerified = manuallyVerified;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        IIdentificationTarget otherEntry = (IIdentificationTarget)other;
        return this.getIdentifier().equals(otherEntry.getIdentifier()) && this.getLibraryInformation().getName().equals(otherEntry.getLibraryInformation().getName()) && this.getLibraryInformation().getCasNumber().equals(otherEntry.getLibraryInformation().getCasNumber()) && this.getComparisonResult().getMatchFactor() == otherEntry.getComparisonResult().getMatchFactor() && this.getComparisonResult().getReverseMatchFactor() == otherEntry.getComparisonResult().getReverseMatchFactor();
    }

    public int hashCode() {
        return 7 * this.identifier.hashCode() + 11 * this.getLibraryInformation().getName().hashCode() + 13 * this.getLibraryInformation().getCasNumber().hashCode() + 11 * Float.valueOf(this.getComparisonResult().getMatchFactor()).hashCode() + 7 * Float.valueOf(this.getComparisonResult().getReverseMatchFactor()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("identifier=" + this.identifier);
        builder.append(",");
        builder.append("name=" + this.getLibraryInformation().getName());
        builder.append(",");
        builder.append("cas=" + this.getLibraryInformation().getCasNumber());
        builder.append(",");
        builder.append(this.getComparisonResult().toString());
        builder.append("]");
        return builder.toString();
    }
}

