/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.signals;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.TotalScanSignalComparator;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.numeric.statistics.Calculations;

public interface ITotalScanSignals
extends Iterable<Integer> {
    public static final float NORMALIZATION_BASE = 1000.0f;

    public IChromatogram getChromatogram();

    public void add(ITotalScanSignal var1);

    public ITotalScanSignal getTotalScanSignal(int var1);

    default public ITotalScanSignal getNextTotalScanSignal(int scan) {
        ITotalScanSignal signal = this.getTotalScanSignal(++scan);
        return signal;
    }

    default public ITotalScanSignal getPreviousTotalScanSignal(int scan) {
        ITotalScanSignal signal = this.getTotalScanSignal(--scan);
        return signal;
    }

    default public ITotalScanSignal getFirstTotalScanSignal() {
        return this.getTotalScanSignal(this.getStartScan());
    }

    default public ITotalScanSignal getLastTotalScanSignal() {
        return this.getTotalScanSignal(this.getStopScan());
    }

    public int size();

    public int getStartScan();

    public int getStopScan();

    default public float getMaxSignal() {
        if (this.size() == 0) {
            return 0.0f;
        }
        float[] values = this.getValues();
        float max = Calculations.getMax((float[])values);
        return max;
    }

    default public float getMinSignal() {
        if (this.size() == 0) {
            return 0.0f;
        }
        float[] values = this.getValues();
        float min = Calculations.getMin((float[])values);
        return min;
    }

    public ITotalScanSignals makeDeepCopy();

    public List<ITotalScanSignal> getTotalScanSignals();

    public List<ITotalScanSignal> getTotalScanSignalList();

    default public ITotalScanSignal getMaxTotalScanSignal() {
        return Collections.max(this.getTotalScanSignalList(), new TotalScanSignalComparator());
    }

    default public ITotalScanSignal getMinTotalScanSignal() {
        return Collections.min(this.getTotalScanSignalList(), new TotalScanSignalComparator());
    }

    default public void setNegativeTotalSignalsToZero() {
        for (ITotalScanSignal signal : this.getTotalScanSignalList()) {
            if (!(signal.getTotalSignal() < 0.0f)) continue;
            signal.setTotalSignal(0.0f);
        }
    }

    default public void setPositiveTotalSignalsToZero() {
        for (ITotalScanSignal signal : this.getTotalScanSignalList()) {
            if (!(signal.getTotalSignal() > 0.0f)) continue;
            signal.setTotalSignal(0.0f);
        }
    }

    default public void setTotalSignalsAsAbsoluteValues() {
        float abundance = 0.0f;
        for (ITotalScanSignal signal : this.getTotalScanSignalList()) {
            abundance = Math.abs(signal.getTotalSignal());
            signal.setTotalSignal(abundance);
        }
    }

    default public float[] getValues() {
        float[] values = new float[this.size()];
        int i = 0;
        for (ITotalScanSignal signal : this.getTotalScanSignalList()) {
            values[i++] = signal.getTotalSignal();
        }
        return values;
    }

    default public float[] getValues(IScanRange range) {
        float[] values = new float[range.getWidth()];
        int counter = 0;
        int scan = range.getStartScan();
        while (scan <= range.getStopScan()) {
            ITotalScanSignal signal = this.getTotalScanSignal(scan);
            values[counter] = signal.getTotalSignal();
            ++counter;
            ++scan;
        }
        return values;
    }
}

