/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.types;

import org.eclipse.chemclipse.processing.DataCategory;

public enum DataType {
    NONE,
    AUTO_DETECT,
    MSD_NOMINAL,
    MSD_TANDEM,
    MSD_HIGHRES,
    MSD,
    CSD,
    WSD,
    XIR,
    NMR,
    CAL,
    PCR,
    SEQ,
    MTH,
    QDB;


    public static DataType fromDataCategory(DataCategory category) {
        switch (category) {
            case MSD: {
                return MSD;
            }
            case WSD: {
                return WSD;
            }
            case CSD: {
                return CSD;
            }
            case FID: 
            case NMR: {
                return NMR;
            }
        }
        return AUTO_DETECT;
    }

    public DataCategory toDataCategory() {
        switch (this) {
            case MSD: {
                return DataCategory.MSD;
            }
            case WSD: {
                return DataCategory.WSD;
            }
            case CSD: {
                return DataCategory.CSD;
            }
            case NMR: {
                return DataCategory.NMR;
            }
        }
        return DataCategory.AUTO_DETECT;
    }

    public static DataCategory[] convert(DataType[] dataTypes) {
        DataCategory[] categories = new DataCategory[dataTypes.length];
        int i = 0;
        while (i < categories.length) {
            categories[i] = dataTypes[i].toDataCategory();
            ++i;
        }
        return categories;
    }

    public static DataType[] convert(DataCategory[] categories) {
        DataType[] dataTypes = new DataType[categories.length];
        int i = 0;
        while (i < categories.length) {
            dataTypes[i] = DataType.fromDataCategory(categories[i]);
            ++i;
        }
        return dataTypes;
    }
}

