/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.identifier;

import org.eclipse.chemclipse.model.identifier.IComparisonResult;

public abstract class AbstractComparisonResult
implements IComparisonResult {
    private static final long serialVersionUID = 1295884624032029498L;
    private boolean isMatch = false;
    private float matchFactor;
    private float matchFactorDirect;
    private float reverseMatchFactor;
    private float reverseMatchFactorDirect;
    private float probability;
    private float penalty;
    private String advise;

    public AbstractComparisonResult(float matchFactor, float reverseMatchFactor, float matchFactorDirect, float reverseMatchFactorDirect) {
        this(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, 100.0f);
    }

    public AbstractComparisonResult(float matchFactor, float reverseMatchFactor, float matchFactorDirect, float reverseMatchFactorDirect, float probability) {
        this.probability = probability;
        this.matchFactor = matchFactor;
        this.reverseMatchFactor = reverseMatchFactor;
        this.matchFactorDirect = matchFactorDirect;
        this.reverseMatchFactorDirect = reverseMatchFactorDirect;
    }

    public AbstractComparisonResult(IComparisonResult comparisonResult) {
        this(comparisonResult.getMatchFactor(), comparisonResult.getReverseMatchFactor(), comparisonResult.getMatchFactorDirect(), comparisonResult.getReverseMatchFactorDirect());
    }

    @Override
    public float getPenalty() {
        return this.penalty;
    }

    @Override
    public void clearPenalty() {
        this.setPenalty(0.0f);
    }

    @Override
    public void setPenalty(float penalty) {
        if (!(penalty >= 0.0f) || !(penalty <= 100.0f)) {
            throw new IllegalArgumentException();
        }
        this.penalty = penalty;
    }

    @Override
    public void addPenalty(float penalty) {
        float newPenalty = this.getPenalty() + penalty;
        if (newPenalty > 100.0f) {
            this.setPenalty(100.0f);
        } else if (newPenalty < 0.0f) {
            this.setPenalty(0.0f);
        } else {
            this.setPenalty(newPenalty);
        }
    }

    @Override
    public boolean isMatch() {
        return this.isMatch;
    }

    @Override
    public AbstractComparisonResult setMatch(boolean match) {
        this.isMatch = match;
        return this;
    }

    @Override
    public final float getMatchFactor() {
        return AbstractComparisonResult.getAdjustedValue(this.getMatchFactorNotAdjusted(), this.getPenalty());
    }

    @Override
    public final float getMatchFactorDirect() {
        return AbstractComparisonResult.getAdjustedValue(this.getMatchFactorDirectNotAdjusted(), this.getPenalty());
    }

    @Override
    public float getMatchFactorNotAdjusted() {
        return this.matchFactor;
    }

    @Override
    public float getMatchFactorDirectNotAdjusted() {
        return this.matchFactorDirect;
    }

    @Override
    public final float getReverseMatchFactor() {
        return AbstractComparisonResult.getAdjustedValue(this.getReverseMatchFactorNotAdjusted(), this.getPenalty());
    }

    @Override
    public final float getReverseMatchFactorDirect() {
        return AbstractComparisonResult.getAdjustedValue(this.getReverseMatchFactorDirectNotAdjusted(), this.getPenalty());
    }

    @Override
    public float getReverseMatchFactorNotAdjusted() {
        return this.reverseMatchFactor;
    }

    @Override
    public float getReverseMatchFactorDirectNotAdjusted() {
        return this.reverseMatchFactorDirect;
    }

    @Override
    public void adjustMatchFactor(float penalty) {
        this.setPenalty(penalty);
    }

    @Override
    public void adjustReverseMatchFactor(float penalty) {
        this.setPenalty(penalty);
    }

    @Override
    public float getProbability() {
        return this.probability;
    }

    @Override
    public String getAdvise() {
        if (this.advise == null) {
            this.advise = this.getMatchFactor() >= 80.0f && this.getReverseMatchFactor() <= 20.0f ? "The target is maybe incomplete or recorded under bad conditions." : (this.getMatchFactor() <= 20.0f && this.getReverseMatchFactor() >= 80.0f ? "The target is maybe convoluted by impurities." : "");
        }
        return this.advise;
    }

    @Override
    public float getRating() {
        float rating = (this.getMatchFactorNotAdjusted() + this.getReverseMatchFactorNotAdjusted()) / 2.0f;
        if (this.getMatchFactorDirectNotAdjusted() > 0.0f) {
            rating = (rating + this.getMatchFactorDirectNotAdjusted()) / 2.0f;
        }
        if (this.getReverseMatchFactorDirectNotAdjusted() > 0.0f) {
            rating = (rating + this.getReverseMatchFactorDirectNotAdjusted()) / 2.0f;
        }
        return rating;
    }

    public static float getAdjustedValue(float value, float penalty) {
        float result = value - penalty;
        if (result < 0.0f) {
            return 0.0f;
        }
        return result;
    }

    @Override
    public int compareTo(IComparisonResult o) {
        int result = Boolean.compare(this.isMatch(), o.isMatch());
        if (result == 0) {
            result = Float.compare(this.getMatchFactor(), o.getMatchFactor());
        }
        if (result == 0) {
            result = Float.compare(this.getReverseMatchFactor(), o.getReverseMatchFactor());
        }
        if (result == 0) {
            result = Float.compare(this.getMatchFactorDirect(), o.getMatchFactorDirect());
        }
        if (result == 0) {
            result = Float.compare(this.getReverseMatchFactorDirect(), o.getReverseMatchFactorDirect());
        }
        return result;
    }

    protected void setMatchFactor(float matchFactor) {
        this.matchFactor = matchFactor;
    }

    protected void setMatchFactorDirect(float matchFactorDirect) {
        this.matchFactorDirect = matchFactorDirect;
    }

    protected void setReverseMatchFactor(float reverseMatchFactor) {
        this.reverseMatchFactor = reverseMatchFactor;
    }

    protected void setReverseMatchFactorDirect(float reverseMatchFactorDirect) {
        this.reverseMatchFactorDirect = reverseMatchFactorDirect;
    }
}

