/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;

public abstract class AbstractQuantitationSignal
implements IQuantitationSignal {
    private double signal = 0.0;
    private double relativeResponse = 100.0;
    private double uncertainty = 0.0;
    private boolean use = true;

    public AbstractQuantitationSignal(double signal, double relativeResponse) {
        this(signal, relativeResponse, 0.0, true);
    }

    public AbstractQuantitationSignal(double signal, double relativeResponse, double uncertainty) {
        this(signal, relativeResponse, uncertainty, true);
    }

    public AbstractQuantitationSignal(double signal, double relativeResponse, double uncertainty, boolean use) {
        this.signal = signal;
        this.relativeResponse = relativeResponse;
        this.uncertainty = uncertainty;
        this.use = use;
    }

    @Override
    public double getSignal() {
        return this.signal;
    }

    @Override
    public double getRelativeResponse() {
        return this.relativeResponse;
    }

    @Override
    public void setRelativeResponse(double relativeResponse) {
        this.relativeResponse = relativeResponse;
    }

    @Override
    public double getUncertainty() {
        return this.uncertainty;
    }

    @Override
    public void setUncertainty(double uncertainty) {
        this.uncertainty = uncertainty;
    }

    @Override
    public boolean isUse() {
        return this.use;
    }

    @Override
    public void setUse(boolean use) {
        this.use = use;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.signal);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQuantitationSignal other = (AbstractQuantitationSignal)obj;
        return Double.doubleToLongBits(this.signal) == Double.doubleToLongBits(other.signal);
    }

    public String toString() {
        return "AbstractQuantitationSignal [signal=" + this.signal + ", relativeResponse=" + this.relativeResponse + ", uncertainty=" + this.uncertainty + ", use=" + this.use + "]";
    }

    @Override
    public int compareTo(IQuantitationSignal quantitationSignal) {
        int result = 0;
        if (quantitationSignal != null) {
            result = Double.compare(this.getSignal(), quantitationSignal.getSignal());
        }
        return result;
    }
}

