/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.converter.msp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.AbstractPeakExportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.internal.converter.SpecificationValidatorMSP;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.PeakWriterMSP;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSPPeakExportConverter
extends AbstractPeakExportConverter {
    private static final Logger logger = Logger.getLogger(MSPPeakExportConverter.class);
    private static final String DESCRIPTION = "AMDIS MSP Peak Export";

    public IProcessingInfo convert(File file, IPeaks peaks, boolean append, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file = SpecificationValidatorMSP.validateSpecification(file), peaks);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                PeakWriterMSP peakWriter = new PeakWriterMSP();
                peakWriter.write(file, peaks, append, monitor);
                processingInfo.setProcessingResult((Object)file);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not writeable: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IPeakMSD peak) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(peak));
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IPeaks peaks) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(peaks));
        return processingInfo;
    }
}

