/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.AbstractWriter;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakWriterMSL
extends AbstractWriter {
    public void write(File file, IPeaks<?> peaks, boolean append, IProgressMonitor monitor) throws FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        for (IPeak peak : peaks.getPeaks()) {
            if (!(peak instanceof IPeakMSD)) continue;
            this.writePeak(fileWriter, (IPeakMSD)peak);
        }
    }

    public void write(File file, IPeakMSD peak, boolean append, IProgressMonitor monitor) throws FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        this.writePeak(fileWriter, peak);
    }

    private void writePeak(FileWriter fileWriter, IPeakMSD peak) throws IOException {
        IPeakMassSpectrum massSpectrum = peak.getExtractedMassSpectrum();
        IScanMSD optimizedMassSpectrum = this.getOptimizedMassSpectrum((IScanMSD)massSpectrum);
        IIdentificationTarget identificationTarget = this.getIdentificationTarget(optimizedMassSpectrum);
        if (identificationTarget == null) {
            identificationTarget = this.getPeakTarget((IPeak)peak);
        } else if ("".equals(identificationTarget.getLibraryInformation().getName())) {
            identificationTarget = this.getIdentificationTarget((IScanMSD)massSpectrum);
        }
        fileWriter.write(String.valueOf(this.getNameField((IScanMSD)massSpectrum, identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getCasNumberField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getSmilesField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getArea(peak)) + "\r\n");
        fileWriter.write(this.getInternalStandards(peak));
        fileWriter.write(this.getQuantitations(peak));
        fileWriter.write(String.valueOf(this.getRetentionTimeField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getRelativeRetentionTimeField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getRetentionIndexField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getDBField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getReferenceIdentifierField(identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getCommentsField(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getSourceField(optimizedMassSpectrum, identificationTarget)) + "\r\n");
        fileWriter.write(String.valueOf(this.getNumberOfPeaks(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write(String.valueOf(this.getIonsFormatMSL(optimizedMassSpectrum)) + "\r\n");
        fileWriter.write("\r\n");
        fileWriter.flush();
    }
}

