/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.animl.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramMSDWriter {
    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            XMLEventWriter eventWriter = xmlOutputFactory.createXMLEventWriter(bufferedOutputStream, "UTF-8");
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            eventWriter.add(eventFactory.createStartDocument());
            eventWriter.add(eventFactory.createComment("Document generated by OpenChrom - the open source software for chromatography/mass spectrometry"));
            eventWriter.add(eventFactory.createStartElement("", "", "AnIML"));
            eventWriter.add(eventFactory.createAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#"));
            eventWriter.add(eventFactory.createAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            eventWriter.add(eventFactory.createAttribute("xsi:schemaLocation", "http://animl.cvs.sourceforge.net/viewvc/animl/schema/animl-core.xsd"));
            eventWriter.add(eventFactory.createAttribute("version", "1.0"));
            this.writeSampleSet(eventWriter, eventFactory, chromatogram, monitor);
            this.writeMeasurementData(eventWriter, eventFactory, chromatogram, monitor);
            this.writeAuditTrailEntrySet(eventWriter, eventFactory, chromatogram, monitor);
            this.writeSignatureSet(eventWriter, eventFactory, chromatogram, monitor);
            eventWriter.add(eventFactory.createEndElement("", "", "AnIML"));
            eventWriter.add(eventFactory.createEndDocument());
            bufferedOutputStream.flush();
            eventWriter.flush();
            bufferedOutputStream.close();
            eventWriter.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeSampleSet(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws XMLStreamException {
        eventWriter.add(eventFactory.createComment("SampleSet is defined in animl-core.xsd"));
        eventWriter.add(eventFactory.createStartElement("", "", "SampleSet"));
        eventWriter.add(eventFactory.createStartElement("", "", "Sample"));
        eventWriter.add(eventFactory.createAttribute("name", chromatogram.getName()));
        eventWriter.add(eventFactory.createAttribute("sampleID", chromatogram.getName()));
        eventWriter.add(eventFactory.createEndElement("", "", "Sample"));
        eventWriter.add(eventFactory.createComment("You can describe one or more samples here"));
        eventWriter.add(eventFactory.createEndElement("", "", "SampleSet"));
    }

    private void writeMeasurementData(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws XMLStreamException {
        eventWriter.add(eventFactory.createComment("MeasurementData is defined in animl-core.xsd"));
        eventWriter.add(eventFactory.createStartElement("", "", "MeasurementData"));
        eventWriter.add(eventFactory.createStartElement("", "", "ExperimentStep"));
        eventWriter.add(eventFactory.createAttribute("name", "MSD_Measurement"));
        eventWriter.add(eventFactory.createStartElement("", "", "Timestamp"));
        eventWriter.add(eventFactory.createCData(chromatogram.getDate().toString()));
        eventWriter.add(eventFactory.createEndElement("", "", "Timestamp"));
        eventWriter.add(eventFactory.createStartElement("", "", "PageSet"));
        eventWriter.add(eventFactory.createStartElement("", "", "Page"));
        eventWriter.add(eventFactory.createAttribute("name", "Scans MSD"));
        eventWriter.add(eventFactory.createStartElement("", "", "VectorSet"));
        eventWriter.add(eventFactory.createAttribute("length", Integer.toString(chromatogram.getNumberOfScans())));
        int scanNumber = 1;
        for (IScan scan : chromatogram.getScans()) {
            monitor.subTask("Export Scan: " + scanNumber);
            if (scan instanceof IScanMSD) {
                IScanMSD massSpectrum = (IScanMSD)scan;
                eventWriter.add(eventFactory.createStartElement("", "", "Vector"));
                eventWriter.add(eventFactory.createAttribute("name", "Scan " + scanNumber));
                eventWriter.add(eventFactory.createAttribute("retentionTime", Double.toString((double)massSpectrum.getRetentionTime() / 60000.0)));
                eventWriter.add(eventFactory.createAttribute("retentionIndex", Float.toString(massSpectrum.getRetentionIndex())));
                for (IIon ion : massSpectrum.getIons()) {
                    eventWriter.add(eventFactory.createStartElement("", "", "Ion"));
                    eventWriter.add(eventFactory.createAttribute("mz", Double.toString(ion.getIon())));
                    eventWriter.add(eventFactory.createAttribute("intensity", Float.toString(ion.getAbundance())));
                    eventWriter.add(eventFactory.createEndElement("", "", "Ion"));
                }
                eventWriter.add(eventFactory.createEndElement("", "", "Vector"));
            }
            ++scanNumber;
        }
        eventWriter.add(eventFactory.createEndElement("", "", "VectorSet"));
        eventWriter.add(eventFactory.createEndElement("", "", "Page"));
        eventWriter.add(eventFactory.createEndElement("", "", "PageSet"));
        eventWriter.add(eventFactory.createEndElement("", "", "ExperimentStep"));
        eventWriter.add(eventFactory.createEndElement("", "", "MeasurementData"));
    }

    private void writeAuditTrailEntrySet(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws XMLStreamException {
        eventWriter.add(eventFactory.createComment("AuditTrail is defined in animl-core.xsd"));
        eventWriter.add(eventFactory.createStartElement("", "", "AuditTrailEntrySet"));
        eventWriter.add(eventFactory.createStartElement("", "", "AuditTrailEntry"));
        eventWriter.add(eventFactory.createEndElement("", "", "AuditTrailEntry"));
        eventWriter.add(eventFactory.createComment("Over time the audit trail will grow when/if you change the file"));
        eventWriter.add(eventFactory.createEndElement("", "", "AuditTrailEntrySet"));
    }

    private void writeSignatureSet(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws XMLStreamException {
        eventWriter.add(eventFactory.createComment("SignatureSet is defined in xmldsig-core-schema.xsd via animl-core.xsd"));
        eventWriter.add(eventFactory.createStartElement("", "", "SignatureSet"));
        eventWriter.add(eventFactory.createStartElement("", "", "Signature"));
        eventWriter.add(eventFactory.createEndElement("", "", "Signature"));
        eventWriter.add(eventFactory.createComment("You can sign all or part of a document"));
        eventWriter.add(eventFactory.createEndElement("", "", "SignatureSet"));
    }
}

