/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.io.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraWriter;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumWriter
implements IMassSpectraWriter {
    private static final Logger logger = Logger.getLogger(MassSpectrumWriter.class);
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public void writeMassSpectrum(FileWriter fileWriter, IScanMSD massSpectrum, IProgressMonitor monitor) throws IOException {
        MassSpectra massSpectra = new MassSpectra();
        massSpectra.addMassSpectrum(massSpectrum);
        this.writeMassSpectrumToCsv((IMassSpectra)massSpectra, fileWriter);
    }

    public void write(File file, IScanMSD massSpectrum, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        MassSpectra massSpectra = new MassSpectra();
        massSpectra.addMassSpectrum(massSpectrum);
        this.writeMassSpectrumToCsv((IMassSpectra)massSpectra, fileWriter);
    }

    public void write(File file, IMassSpectra massSpectra, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        this.writeMassSpectrumToCsv(massSpectra, fileWriter);
    }

    private void writeMassSpectrumToCsv(IMassSpectra massSpectra, FileWriter fileWriter) throws IOException {
        if (massSpectra != null) {
            try (CSVPrinter csvFilePrinter = null;){
                csvFilePrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.EXCEL);
                for (IScanMSD massSpectrum : massSpectra.getList()) {
                    IScanMSD massSpectrumExport;
                    try {
                        massSpectrumExport = massSpectrum.makeDeepCopy();
                        massSpectrumExport.normalize(1000.0f);
                    }
                    catch (CloneNotSupportedException e) {
                        logger.warn((Object)e);
                        massSpectrumExport = massSpectrum;
                    }
                    csvFilePrinter.printRecord(new Object[]{"m/z", "intensity"});
                    List ions = massSpectrum.getIons();
                    for (IIon ion : ions) {
                        String mz = this.decimalFormat.format(ion.getIon());
                        String intensity = this.decimalFormat.format(ion.getAbundance());
                        csvFilePrinter.printRecord(new Object[]{mz, intensity});
                    }
                    csvFilePrinter.printRecord(new Object[]{""});
                }
            }
        }
    }
}

