/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignals;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;

public class ExtractedIonSignalExtractor
implements IExtractedIonSignalExtractor {
    private final IChromatogramMSD chromatogram;

    public ExtractedIonSignalExtractor(IChromatogramMSD chromatogram) throws ChromatogramIsNullException {
        if (chromatogram == null) {
            throw new ChromatogramIsNullException();
        }
        this.chromatogram = chromatogram;
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals(float startIon, float stopIon) {
        int startScan = 1;
        int stopScan = this.chromatogram.getNumberOfScans();
        return this.getExtractedIonSignals(startScan, stopScan, startIon, stopIon);
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals() {
        int startScan = 1;
        int stopScan = this.chromatogram.getNumberOfScans();
        return this.getExtractedIonSignals(startScan, stopScan);
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals(IRetentionTimeRange chromatogramSelection) {
        if (chromatogramSelection == null) {
            return new ExtractedIonSignals(0, this.chromatogram);
        }
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        return this.getExtractedIonSignals(startScan, stopScan);
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals(int startScan, int stopScan) {
        return this.getExtractedIonSignals(startScan, stopScan, 0.0f, 0.0f);
    }

    private IExtractedIonSignals getExtractedIonSignals(int startScan, int stopScan, float startIon, float stopIon) {
        if (this.chromatogram.getNumberOfScans() == 0) {
            return new ExtractedIonSignals(0, this.chromatogram);
        }
        if (startScan > stopScan) {
            int tmp = startScan;
            startScan = stopScan;
            stopScan = tmp;
        }
        stopScan = stopScan > this.chromatogram.getNumberOfScans() ? this.chromatogram.getNumberOfScans() : stopScan;
        int start = startScan < 1 ? 1 : startScan;
        int stop = stopScan;
        int scan = start;
        while (scan <= stop) {
            if (this.chromatogram.getSupplierScan(scan).getNumberOfIons() > 0) {
                startScan = scan;
                break;
            }
            ++scan;
        }
        scan = stop;
        while (scan > startScan) {
            if (this.chromatogram.getSupplierScan(scan).getNumberOfIons() == 0) {
                stopScan = scan - 1;
            }
            --scan;
        }
        ExtractedIonSignals extractedIonSignals = new ExtractedIonSignals(startScan, stopScan, this.chromatogram);
        int scan2 = startScan;
        while (scan2 <= stopScan) {
            this.extractSignals(extractedIonSignals, this.chromatogram.getSupplierScan(scan2), startIon, stopIon);
            ++scan2;
        }
        return extractedIonSignals;
    }

    private boolean extractSignals(IExtractedIonSignals extractedIonSignals, IScanMSD scanMSD, float startIon, float stopIon) {
        if (scanMSD.getNumberOfIons() > 0) {
            if (startIon == 0.0f && stopIon == 0.0f) {
                extractedIonSignals.add(scanMSD.getExtractedIonSignal());
            } else {
                extractedIonSignals.add(scanMSD.getExtractedIonSignal(startIon, stopIon));
            }
            return true;
        }
        return false;
    }
}

