/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractScanIon;
import org.eclipse.chemclipse.msd.model.core.IScanIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;

public class ScanIon
extends AbstractScanIon
implements IScanIon {
    private static final long serialVersionUID = -6040183420395784397L;
    public static final float MIN_ABUNDANCE = Float.MIN_VALUE;
    public static final float MAX_ABUNDANCE = Float.MAX_VALUE;
    public static final double MIN_Ion = 0.5;
    public static final double MAX_Ion = 65535.0;

    public ScanIon(double ion) throws IonLimitExceededException {
        super(ion);
    }

    public ScanIon(double ion, boolean ignoreAbundanceLimit) throws IonLimitExceededException {
        super(ion, ignoreAbundanceLimit);
    }

    public ScanIon(double ion, float abundance) throws AbundanceLimitExceededException, IonLimitExceededException {
        super(ion, abundance);
    }

    @Override
    public float getMinPossibleAbundanceValue() {
        return Float.MIN_VALUE;
    }

    @Override
    public float getMaxPossibleAbundanceValue() {
        return Float.MAX_VALUE;
    }

    @Override
    public double getMinPossibleIonValue() {
        return 0.5;
    }

    @Override
    public double getMaxPossibleIonValue() {
        return 65535.0;
    }
}

