/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignal;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.xic.ITotalIonSignalExtractor;

public class TotalIonSignalExtractor
extends TotalScanSignalExtractor
implements ITotalIonSignalExtractor {
    private IChromatogramMSD chromatogram;

    public TotalIonSignalExtractor(IChromatogramMSD chromatogram) throws ChromatogramIsNullException {
        super((IChromatogram)chromatogram);
        this.chromatogram = chromatogram;
    }

    @Override
    public ITotalScanSignals getTotalIonSignals(int startScan, int stopScan, IMarkedIons excludedIons) {
        if (startScan > stopScan) {
            int tmp = startScan;
            startScan = stopScan;
            stopScan = tmp;
        }
        return this.initializeTotalIonSignals(startScan, stopScan, excludedIons);
    }

    @Override
    public ITotalScanSignals getTotalIonSignals(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons excludedIons) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() != this.chromatogram) {
            return new TotalScanSignals(0, (IChromatogram)this.chromatogram);
        }
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        ITotalScanSignals signals = this.initializeTotalIonSignals(startScan, stopScan, excludedIons);
        return signals;
    }

    @Override
    public ITotalScanSignals getTotalIonSignals(IChromatogramSelectionMSD chromatogramSelection) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() != this.chromatogram) {
            return new TotalScanSignals(0, (IChromatogram)this.chromatogram);
        }
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        ITotalScanSignals signals = this.initializeTotalIonSignals(startScan, stopScan, null);
        return signals;
    }

    @Override
    public ITotalScanSignals getTotalIonSignals(IMarkedIons excludedIons) {
        return this.initializeTotalIonSignals(excludedIons);
    }

    private ITotalScanSignals initializeTotalIonSignals(int startScan, int stopScan, IMarkedIons excludedIons) {
        assert (startScan <= stopScan) : "The startScan must be lower or equal the stop scan.";
        if (startScan < 1 || startScan > this.chromatogram.getNumberOfScans() || stopScan < 1 || stopScan > this.chromatogram.getNumberOfScans()) {
            return new TotalScanSignals(0, (IChromatogram)this.chromatogram);
        }
        TotalScanSignals signals = new TotalScanSignals(startScan, stopScan, (IChromatogram)this.chromatogram);
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum ms = this.chromatogram.getSupplierScan(scan);
            TotalScanSignal totalIonSignal = new TotalScanSignal(ms.getRetentionTime(), ms.getRetentionIndex(), ms.getTotalSignal(excludedIons));
            signals.add((ITotalScanSignal)totalIonSignal);
            ++scan;
        }
        return signals;
    }

    private ITotalScanSignals initializeTotalIonSignals(IMarkedIons excludedIons) {
        TotalScanSignals signals = new TotalScanSignals(this.chromatogram.getNumberOfScans(), (IChromatogram)this.chromatogram);
        for (IScan scan : this.chromatogram.getScans()) {
            if (!(scan instanceof IVendorMassSpectrum)) continue;
            IVendorMassSpectrum ms = (IVendorMassSpectrum)scan;
            TotalScanSignal totalIonSignal = new TotalScanSignal(ms.getRetentionTime(), ms.getRetentionIndex(), ms.getTotalSignal(excludedIons));
            signals.add((ITotalScanSignal)totalIonSignal);
        }
        return signals;
    }
}

