/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.matrix;

import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonBounds;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;

public class ExtractedMatrix {
    private IChromatogramSelectionMSD selection;
    private List<IScanMSD> scans;
    private int startIon;
    private int stopIon;
    private double[][] signal;

    public ExtractedMatrix(IChromatogramSelectionMSD chromatogramSelection) {
        this.selection = chromatogramSelection;
        this.scans = this.extractScans();
        if (this.checkHighRes(10).booleanValue()) {
            throw new IllegalArgumentException("HighRes MSD is currently not suported");
        }
        int[] minMaxMz = this.getMinMaxMz();
        this.startIon = minMaxMz[0];
        this.stopIon = minMaxMz[1];
        int numberOfScans = this.selection.getStopScan() - this.selection.getStartScan() + 1;
        int numberOfIons = this.stopIon - this.startIon + 1;
        this.signal = new double[numberOfScans][numberOfIons];
        int scanIndex = 0;
        while (scanIndex < numberOfScans) {
            List currentIons = this.scans.get(scanIndex).getIons();
            for (IIon ion : currentIons) {
                this.signal[scanIndex][(int)Math.round((double)(ion.getIon() - (double)this.startIon))] = ion.getAbundance();
            }
            ++scanIndex;
        }
    }

    private Boolean checkHighRes(int limit) {
        for (IScanMSD scan : this.scans) {
            IIonBounds bounds = scan.getIonBounds();
            double rangeAbs = bounds.getHighestIon().getIon() - bounds.getLowestIon().getIon();
            if (!(rangeAbs + (double)limit < (double)scan.getIons().size())) continue;
            return true;
        }
        return false;
    }

    private List<IScanMSD> extractScans() {
        int startRT = this.selection.getStartRetentionTime();
        int stopRT = this.selection.getStopRetentionTime();
        List<IScanMSD> scans = ((IChromatogramMSD)this.selection.getChromatogram()).getScans().stream().filter(s -> s instanceof IScanMSD).map(IScanMSD.class::cast).filter(s -> s.getRetentionTime() >= startRT).filter(s -> s.getRetentionTime() <= stopRT).collect(Collectors.toList());
        return scans;
    }

    private int[] getMinMaxMz() {
        int[] minMaxMz = new int[2];
        Stream<Double> s = this.scans.stream().flatMap(scan -> scan.getIons().stream()).map(x -> x.getIon());
        DoubleSummaryStatistics d = s.collect(Collectors.summarizingDouble(value -> value));
        minMaxMz[0] = AbstractIon.getIon(d.getMin());
        minMaxMz[1] = AbstractIon.getIon(d.getMax());
        return minMaxMz;
    }

    public double[][] getMatrix() {
        return this.signal;
    }

    public void updateSignal() {
        try {
            int i = 1;
            while (i <= this.signal.length) {
                IScanMSD currentScan = (IScanMSD)((IChromatogramMSD)this.selection.getChromatogram()).getScan(i);
                currentScan.removeAllIons();
                int j = this.startIon;
                while (j < this.stopIon) {
                    if (this.signal[i - 1][j - this.startIon] != 0.0) {
                        Ion currentIon = new Ion(j, (float)this.signal[i - 1][j - this.startIon]);
                        currentScan.addIon(currentIon);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating the Signal failed:", e);
        }
    }

    public int[] getScanNumbers() {
        int[] scanNumbers = this.scans.stream().mapToInt(scan -> scan.getScanNumber()).toArray();
        return scanNumbers;
    }

    public int[] getRetentionTimes() {
        int[] retentionTimes = this.scans.stream().mapToInt(scan -> scan.getRetentionTime()).toArray();
        return retentionTimes;
    }
}

