/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractScanMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;

public class ScanMSD
extends AbstractScanMSD
implements IScanMSD {
    private static final long serialVersionUID = -1794251778820195779L;
    private static final Logger logger = Logger.getLogger(ScanMSD.class);

    public ScanMSD() {
    }

    public ScanMSD(Collection<? extends IIon> ions) {
        super(ions);
    }

    public ScanMSD(IScanMSD templateScan) {
        super(templateScan);
    }

    @Override
    public IScanMSD makeDeepCopy() throws CloneNotSupportedException {
        IScanMSD massSpectrum = (IScanMSD)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                Ion defaultIon = new Ion(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon(defaultIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    @Override
    public ScanMSD addIons(List<IIon> ions, boolean addIntensities) {
        super.addIons((List)ions, addIntensities);
        return this;
    }

    @Override
    public ScanMSD addIon(IIon ion) {
        super.addIon(ion);
        return this;
    }

    @Override
    public ScanMSD addIon(IIon ion, boolean checked) {
        super.addIon(ion, checked);
        return this;
    }

    @Override
    public ScanMSD addIon(boolean addIntensity, IIon ion) {
        super.addIon(addIntensity, ion);
        return this;
    }

    @Override
    protected IScanMSD clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

