/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.statistics.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.inference.OneWayAnova;
import org.eclipse.chemclipse.numeric.statistics.model.IAnovaStatistics;
import org.eclipse.chemclipse.numeric.statistics.model.IStatisticsElement;

public class AnovaStatistics
implements IAnovaStatistics {
    Collection<double[]> anovaInput;

    public <T> AnovaStatistics(IStatisticsElement<IStatisticsElement<T>> groupedStatisticsElement, Method getdata) {
        List<IStatisticsElement<T>> groupedStatisticsElements = groupedStatisticsElement.getIncludedSourceElements();
        this.anovaInput = new ArrayList<double[]>(groupedStatisticsElements.size());
        if (groupedStatisticsElements.size() > 1) {
            for (IStatisticsElement<T> gse : groupedStatisticsElements) {
                List<T> statisticsElements = gse.getIncludedSourceElements();
                int size = statisticsElements.size();
                if (size <= 1) continue;
                double[] values = new double[size];
                int i = 0;
                while (i < size) {
                    T t = statisticsElements.get(i);
                    try {
                        Number data = (Number)getdata.invoke(t, new Object[0]);
                        values[i] = data.doubleValue();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                this.anovaInput.add(values);
            }
        }
    }

    @Override
    public double getPValue() {
        OneWayAnova anova = new OneWayAnova();
        double pvalue = anova.anovaPValue(this.anovaInput);
        return pvalue;
    }

    @Override
    public double getFValue() {
        OneWayAnova anova = new OneWayAnova();
        double fvalue = anova.anovaFValue(this.anovaInput);
        return fvalue;
    }
}

