/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.supplier;

import java.io.IOException;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.support.settings.SystemSettingsStrategy;
import org.eclipse.chemclipse.support.settings.parser.SettingsParser;
import org.eclipse.chemclipse.support.settings.serialization.JSONSerialization;
import org.eclipse.chemclipse.support.settings.serialization.SettingsSerialization;

public interface ProcessorPreferences<SettingType> {
    public static final SettingsSerialization DEFAULT_SETTINGS_SERIALIZATION = new JSONSerialization();

    public DialogBehavior getDialogBehaviour();

    public void setAskForSettings(boolean var1);

    public void setUserSettings(String var1);

    public boolean isUseSystemDefaults();

    public void setUseSystemDefaults(boolean var1);

    public void reset();

    default public SettingsSerialization getSerialization() {
        return DEFAULT_SETTINGS_SERIALIZATION;
    }

    default public SettingType getUserSettings() throws IOException {
        String serializedString = this.getUserSettingsAsString();
        Class<SettingType> settingsClass = this.getSupplier().getSettingsClass();
        if (serializedString == null || settingsClass == null) {
            return null;
        }
        Object defaultInstance = this.getSupplier().getSettingsParser().createDefaultInstance();
        this.getSerialization().updateFromString(defaultInstance, serializedString);
        return (SettingType)defaultInstance;
    }

    default public SettingType getSystemSettings() throws IOException {
        IProcessSupplier<SettingType> supplier = this.getSupplier();
        SettingsParser<SettingType> settingsParser = supplier.getSettingsParser();
        if (settingsParser.getSystemSettingsStrategy() == SystemSettingsStrategy.NEW_INSTANCE) {
            return (SettingType)settingsParser.createDefaultInstance();
        }
        return null;
    }

    default public SettingType getSettings() throws IOException {
        if (this.isUseSystemDefaults()) {
            return this.getSystemSettings();
        }
        return this.getUserSettings();
    }

    default public boolean requiresUserSettings() {
        IProcessSupplier<SettingType> supplier = this.getSupplier();
        SystemSettingsStrategy strategy = supplier.getSettingsParser().getSystemSettingsStrategy();
        return strategy == SystemSettingsStrategy.NONE || strategy == SystemSettingsStrategy.DYNAMIC;
    }

    public IProcessSupplier<SettingType> getSupplier();

    public String getUserSettingsAsString();

    public static enum DialogBehavior {
        SHOW,
        SAVED_DEFAULTS,
        NONE;

    }
}

