/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.methods;

import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;

public final class SubProcessExecutionConsumer<T>
implements ProcessExecutionConsumer<T> {
    private final ProcessExecutionConsumer<T> intercepted;
    private final SubProcess<T> subprocess;

    public SubProcessExecutionConsumer(ProcessExecutionConsumer<T> parent, SubProcess<T> subprocess) {
        this.intercepted = parent;
        this.subprocess = subprocess;
    }

    @Override
    public <X> void execute(ProcessorPreferences<X> preferences, ProcessExecutionContext context) throws Exception {
        ProcessExecutionContext ctx2;
        if (this.intercepted.canExecute(preferences)) {
            context.setWorkRemaining(2);
            ProcessExecutionContext ctx1 = context.split();
            ctx1.setContextObject(ProcessExecutionConsumer.class, this.intercepted);
            this.intercepted.execute(preferences, ctx1);
            ctx2 = context.split();
        } else {
            ctx2 = context;
        }
        this.subprocess.execute(preferences, this.intercepted, ctx2);
    }

    @Override
    public T getResult() {
        return this.intercepted.getResult();
    }

    @Override
    public ProcessExecutionConsumer<T> withResult(Object initialResult) {
        ProcessExecutionConsumer<T> withResult = this.intercepted.withResult(initialResult);
        if (withResult == null) {
            return null;
        }
        return new SubProcessExecutionConsumer<T>(withResult, this.subprocess);
    }

    @FunctionalInterface
    public static interface SubProcess<SubType> {
        public <SubX> void execute(ProcessorPreferences<SubX> var1, ProcessExecutionConsumer<SubType> var2, ProcessExecutionContext var3);
    }
}

