/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.preferences;

import java.io.File;
import org.eclipse.chemclipse.rcp.app.ui.Activator;
import org.eclipse.chemclipse.support.settings.ApplicationSettings;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.SpacerFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SettingsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public SettingsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Settings");
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        Button resetSettings = new Button(this.getFieldEditorParent(), 0);
        resetSettings.setText("Reset Application Settings");
        resetSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 456);
                messageBox.setText("Reset?");
                messageBox.setMessage("Do you really want to reset the application? Please backup your files, databases ... they will be deleted using this option.");
                if (messageBox.open() == 64) {
                    File settingsDirectory = ApplicationSettings.getSettingsDirectory();
                    SettingsPreferencePage.this.deleteFiles(new File[]{settingsDirectory});
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
    }

    private void deleteFiles(File[] files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.deleteFiles(file.listFiles());
                file.delete();
            } else {
                file.delete();
            }
            ++n2;
        }
    }
}

