/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.support.ui.preferences.editors.IonInputValidator;
import org.eclipse.chemclipse.support.ui.preferences.editors.TableViewerFieldEditor;
import org.eclipse.chemclipse.support.util.IonSettingUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;

public class IonTableEditor
extends TableViewerFieldEditor<String> {
    private IonSettingUtil settinngUtils = new IonSettingUtil();

    public IonTableEditor(String name, String labelText, Composite parent) {
        super(name, labelText, new String[]{"Ions"}, new int[]{200}, parent);
    }

    @Override
    protected String createSavePreferences(List<String> values) {
        return this.settinngUtils.serialize(values);
    }

    @Override
    protected List<String> parseSavePreferences(String string) {
        return this.settinngUtils.deserialize(string);
    }

    @Override
    protected String convertColumnValue(String value, int numberColumn) {
        return value;
    }

    @Override
    protected List<String> getNewInputObject() {
        InputDialog dialog = new InputDialog(this.getShell(), "Enter a ion.", "Standard values are 18 (water), 28 (nitrogen), 84 (solvent tailing), 207 (column bleed).", "", (IInputValidator)new IonInputValidator());
        dialog.create();
        if (dialog.open() == 0) {
            String ion = dialog.getValue();
            return this.settinngUtils.parseInput(ion);
        }
        return new ArrayList<String>();
    }

    @Override
    protected int compareValue(String value1, String value2, int columnNumber) {
        return this.settinngUtils.compare(value1, value2);
    }
}

