/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.HashSet;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EnhancedTreeViewer
extends Composite {
    private static final String POPUP_MENU_ID = "#PopUpMenu";
    private static final String POPUP_MENU_POSTFIX = "PopUpMenu";
    private TreeViewer treeViewer;
    private Clipboard clipboard;

    public EnhancedTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.createControl();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setContentProvider(IContentProvider provider) {
        this.treeViewer.setContentProvider(provider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.treeViewer.setLabelProvider(labelProvider);
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    private void createControl() {
        this.clipboard = new Clipboard(Display.getDefault());
        this.treeViewer = new TreeViewer((Composite)this, 2818);
        this.treeViewer.getTree().setLayout((Layout)new FillLayout());
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99) {
                    int cfr_ignored_0 = e.stateMask;
                }
            }
        });
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    EnhancedTreeViewer.this.copyToClipboard();
                }
            }
        });
        this.initContextMenu(this.treeViewer);
    }

    private void initContextMenu(TreeViewer treeViewer) {
        MenuManager menuManager = new MenuManager(POPUP_MENU_ID, String.valueOf(((Object)((Object)this)).getClass().getName()) + POPUP_MENU_POSTFIX);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        EnhancedTreeViewer.this.copyToClipboard();
                    }
                };
                action.setText(SupportMessages.INSTANCE().getMessage("labelCopySelectionClipboard", new String[0]));
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
    }

    private void copyToClipboard() {
        String END_OF_LINE = OperatingSystemUtils.getLineDelimiter();
        StringBuilder builder = new StringBuilder();
        Tree tree = this.treeViewer.getTree();
        HashSet<TreeItem> rootItems = new HashSet<TreeItem>();
        TreeItem[] treeItemArray = tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            rootItems.add(this.getRootItem(treeItem));
            ++n2;
        }
        for (TreeItem treeItem : rootItems) {
            this.copyTreeToClipboard(treeItem, builder, "");
            builder.append(END_OF_LINE);
        }
        if (builder.length() == 0) {
            builder.append(SupportMessages.INSTANCE().getMessage("labelCopyLinesInfo", new String[0]));
            builder.append(END_OF_LINE);
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{builder.toString()};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        this.clipboard.setContents(data, dataTypes);
    }

    private TreeItem getRootItem(TreeItem treeItem) {
        TreeItem treeItemx = treeItem;
        while (treeItemx.getParentItem() != null) {
            treeItemx = treeItemx.getParentItem();
        }
        return treeItemx;
    }

    private void copyTreeToClipboard(TreeItem treeItem, StringBuilder builder, String intend) {
        String DELIMITER = "\t";
        String END_OF_LINE = OperatingSystemUtils.getLineDelimiter();
        if (!treeItem.getText().equals("")) {
            builder.append(String.valueOf(intend) + treeItem.getText());
            builder.append(END_OF_LINE);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeSubItem = treeItemArray[n2];
            this.copyTreeToClipboard(treeSubItem, builder, String.valueOf(intend) + DELIMITER);
            ++n2;
        }
    }
}

